"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Priority = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _optional_field_label = require("../../../common/optional_field_label");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PriorityComponent = ({
  priority,
  onChange
}) => {
  const onPriorityChange = (0, _react.useCallback)(event => {
    onChange('priority', event.target.value);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.PRIORITY_LABEL,
    "data-test-subj": "opsgenie-priority-row",
    labelAppend: _optional_field_label.OptionalFieldLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "opsgenie-prioritySelect",
    options: priorityOptions,
    hasNoInitialSelection: true,
    value: priority,
    onChange: onPriorityChange
  }));
};
PriorityComponent.displayName = 'Priority';
const Priority = exports.Priority = /*#__PURE__*/_react.default.memo(PriorityComponent);
const priorityOptions = [{
  value: 'P1',
  text: i18n.PRIORITY_1,
  ['data-test-subj']: 'opsgenie-priority-p1'
}, {
  value: 'P2',
  text: i18n.PRIORITY_2,
  ['data-test-subj']: 'opsgenie-priority-p2'
}, {
  value: 'P3',
  text: i18n.PRIORITY_3,
  ['data-test-subj']: 'opsgenie-priority-p3'
}, {
  value: 'P4',
  text: i18n.PRIORITY_4,
  ['data-test-subj']: 'opsgenie-priority-p4'
}, {
  value: 'P5',
  text: i18n.PRIORITY_5,
  ['data-test-subj']: 'opsgenie-priority-p5'
}];