"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateJSON = exports.MAX_ATTRIBUTES_ERROR = exports.INVALID_JSON_FORMAT = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isObject = value => {
  return (0, _lodash.isPlainObject)(value);
};
const MAX_ATTRIBUTES_ERROR = length => _i18n.i18n.translate('xpack.stackConnectors.schema.additionalFieldsLengthError', {
  values: {
    length
  },
  defaultMessage: 'A maximum of {length} additional fields can be defined at a time.'
});
exports.MAX_ATTRIBUTES_ERROR = MAX_ATTRIBUTES_ERROR;
const INVALID_JSON_FORMAT = exports.INVALID_JSON_FORMAT = _i18n.i18n.translate('xpack.stackConnectors.components.otherFieldsFormatErrorMessage', {
  defaultMessage: 'Invalid JSON.'
});
const validateJSON = ({
  value,
  maxProperties
}) => {
  try {
    if (isObject(value)) {
      return;
    }
    if (value) {
      const parsedOtherFields = JSON.parse(value);
      if (maxProperties && Object.keys(parsedOtherFields).length > maxProperties) {
        return MAX_ATTRIBUTES_ERROR(maxProperties);
      }
    }
  } catch (error) {
    return INVALID_JSON_FORMAT;
  }
};
exports.validateJSON = validateJSON;