"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsByIssueType = getFieldsByIssueType;
exports.getIssue = getIssue;
exports.getIssueTypes = getIssueTypes;
exports.getIssues = getIssues;
var _common = require("@kbn/actions-plugin/common");
var _rewrite_response_body = require("../lib/rewrite_response_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIssueTypes({
  http,
  signal,
  connectorId
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'issueTypes',
        subActionParams: {}
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}
async function getFieldsByIssueType({
  http,
  signal,
  connectorId,
  id
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'fieldsByIssueType',
        subActionParams: {
          id
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}
async function getIssues({
  http,
  signal,
  connectorId,
  title
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'issues',
        subActionParams: {
          title
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}
async function getIssue({
  http,
  signal,
  connectorId,
  id
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'issue',
        subActionParams: {
          id
        }
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}