"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProviderSecretsHiddenField = exports.getProviderConfigHiddenField = void 0;
var _react = _interopRequireDefault(require("react"));
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getProviderSecretsHiddenField = (providerSchema, setRequiredProviderFormFields, isSubmitting) => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "secrets.providerSecrets",
  component: _components.HiddenField,
  config: {
    validations: [{
      validator: (0, _helpers.getNonEmptyValidator)(providerSchema, setRequiredProviderFormFields, isSubmitting, true),
      isBlocking: true
    }]
  }
});
exports.getProviderSecretsHiddenField = getProviderSecretsHiddenField;
const getProviderConfigHiddenField = (providerSchema, setRequiredProviderFormFields, isSubmitting) => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: "config.providerConfig",
  component: _components.HiddenField,
  config: {
    validations: [{
      validator: (0, _helpers.getNonEmptyValidator)(providerSchema, setRequiredProviderFormFields, isSubmitting),
      isBlocking: true
    }]
  }
});
exports.getProviderConfigHiddenField = getProviderConfigHiddenField;