"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTaskTypeOptions = exports.getNonEmptyValidator = exports.generateInferenceEndpointId = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTaskTypeOptions = taskTypes => taskTypes.map(taskType => ({
  id: taskType,
  label: taskType,
  value: taskType
}));
exports.getTaskTypeOptions = getTaskTypeOptions;
const generateInferenceEndpointId = (config, setFieldValue) => {
  const taskTypeSuffix = config.taskType ? `${config.taskType}-` : '';
  const inferenceEndpointId = `${config.provider}-${taskTypeSuffix}${Math.random().toString(36).slice(2)}`;
  config.inferenceId = inferenceEndpointId;
  setFieldValue('config.inferenceId', inferenceEndpointId);
};
exports.generateInferenceEndpointId = generateInferenceEndpointId;
const getNonEmptyValidator = (schema, validationEventHandler, isSubmitting = false, isSecrets = false) => {
  return (...args) => {
    const [{
      value,
      path
    }] = args;
    const newSchema = [];
    const configData = value !== null && value !== void 0 ? value : {};
    let hasErrors = false;
    if (schema) {
      schema.filter(f => f.required).forEach(field => {
        // validate if submitting or on field edit - value is not default to null
        if (configData[field.key] !== null || isSubmitting) {
          // validate secrets fields separately from regular
          if (isSecrets ? field.sensitive : !field.sensitive) {
            if (!configData[field.key] || typeof configData[field.key] === 'string' && (0, _fp.isEmpty)(configData[field.key])) {
              field.validationErrors = [i18n.getRequiredMessage(field.label)];
              field.isValid = false;
              hasErrors = true;
            } else {
              field.validationErrors = [];
              field.isValid = true;
            }
          }
        }
        newSchema.push(field);
      });
      validationEventHandler(newSchema);
      if (hasErrors) {
        return {
          code: 'ERR_FIELD_MISSING',
          path,
          message: i18n.getRequiredMessage('Action')
        };
      }
    }
  };
};
exports.getNonEmptyValidator = getNonEmptyValidator;