"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorTypes = registerConnectorTypes;
var _microsoft_defender_endpoint = require("./microsoft_defender_endpoint");
var _cases_webhook = require("./cases_webhook");
var _email = require("./email");
var _es_index = require("./es_index");
var _jira = require("./jira");
var _openai = require("./openai");
var _bedrock = require("./bedrock");
var _gemini = require("./gemini");
var _inference = require("./inference");
var _opsgenie = require("./opsgenie");
var _pagerduty = require("./pagerduty");
var _resilient = require("./resilient");
var _server_log = require("./server_log");
var _servicenow_itom = require("./servicenow_itom");
var _servicenow_itsm = require("./servicenow_itsm");
var _servicenow_sir = require("./servicenow_sir");
var _slack = require("./slack");
var _slack_api = require("./slack_api");
var _swimlane = require("./swimlane");
var _teams = require("./teams");
var _tines = require("./tines");
var _torq = require("./torq");
var _webhook = require("./webhook");
var _xmatters = require("./xmatters");
var _d3security = require("./d3security");
var _experimental_features_service = require("../common/experimental_features_service");
var _sentinelone = require("./sentinelone");
var _thehive = require("./thehive");
var _crowdstrike = require("./crowdstrike");
var _xsoar = require("./xsoar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConnectorTypes({
  connectorTypeRegistry,
  services
}) {
  connectorTypeRegistry.register((0, _server_log.getServerLogConnectorType)());
  connectorTypeRegistry.register((0, _slack.getSlackWebhookConnectorType)());
  connectorTypeRegistry.register((0, _slack_api.getSlackApiConnectorType)());
  connectorTypeRegistry.register((0, _email.getEmailConnectorType)(services));
  connectorTypeRegistry.register((0, _es_index.getIndexConnectorType)());
  connectorTypeRegistry.register((0, _pagerduty.getPagerDutyConnectorType)());
  connectorTypeRegistry.register((0, _swimlane.getSwimlaneConnectorType)());
  connectorTypeRegistry.register((0, _cases_webhook.getCasesWebhookConnectorType)());
  connectorTypeRegistry.register((0, _webhook.getWebhookConnectorType)());
  connectorTypeRegistry.register((0, _xmatters.getXmattersConnectorType)());
  connectorTypeRegistry.register((0, _servicenow_itsm.getServiceNowITSMConnectorType)());
  connectorTypeRegistry.register((0, _servicenow_itom.getServiceNowITOMConnectorType)());
  connectorTypeRegistry.register((0, _servicenow_sir.getServiceNowSIRConnectorType)());
  connectorTypeRegistry.register((0, _jira.getJiraConnectorType)());
  connectorTypeRegistry.register((0, _resilient.getResilientConnectorType)());
  connectorTypeRegistry.register((0, _opsgenie.getOpsgenieConnectorType)());
  connectorTypeRegistry.register((0, _openai.getOpenAIConnectorType)());
  connectorTypeRegistry.register((0, _bedrock.getBedrockConnectorType)());
  connectorTypeRegistry.register((0, _gemini.getGeminiConnectorType)());
  connectorTypeRegistry.register((0, _teams.getTeamsConnectorType)());
  connectorTypeRegistry.register((0, _torq.getTorqConnectorType)());
  connectorTypeRegistry.register((0, _tines.getTinesConnectorType)());
  connectorTypeRegistry.register((0, _d3security.getD3SecurityConnectorType)());
  connectorTypeRegistry.register((0, _thehive.getTheHiveConnectorType)());
  connectorTypeRegistry.register((0, _xsoar.getXSOARConnectorType)());
  if (_experimental_features_service.ExperimentalFeaturesService.get().sentinelOneConnectorOn) {
    connectorTypeRegistry.register((0, _sentinelone.getSentinelOneConnectorType)());
  }
  if (_experimental_features_service.ExperimentalFeaturesService.get().crowdstrikeConnectorOn) {
    connectorTypeRegistry.register((0, _crowdstrike.getCrowdStrikeConnectorType)());
  }
  if (!_experimental_features_service.ExperimentalFeaturesService.get().inferenceConnectorOff) {
    connectorTypeRegistry.register((0, _inference.getInferenceConnectorType)());
  }
  if (_experimental_features_service.ExperimentalFeaturesService.get().microsoftDefenderEndpointOn) {
    connectorTypeRegistry.register((0, _microsoft_defender_endpoint.getMicrosoftDefenderEndpointConnectorType)());
  }
}