"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XSOAR_TITLE = exports.XSOAR_CONNECTOR_ID = exports.XSOARSeverity = exports.SUB_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const XSOAR_TITLE = exports.XSOAR_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.connectorTypeTitle', {
  defaultMessage: 'XSOAR'
});
const XSOAR_CONNECTOR_ID = exports.XSOAR_CONNECTOR_ID = '.xsoar';
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["PLAYBOOKS"] = "getPlaybooks";
  SUB_ACTION["RUN"] = "run";
  return SUB_ACTION;
}({});
let XSOARSeverity = exports.XSOARSeverity = /*#__PURE__*/function (XSOARSeverity) {
  XSOARSeverity[XSOARSeverity["INFORMATIONAL"] = 0.5] = "INFORMATIONAL";
  XSOARSeverity[XSOARSeverity["UNKNOWN"] = 0] = "UNKNOWN";
  XSOARSeverity[XSOARSeverity["LOW"] = 1] = "LOW";
  XSOARSeverity[XSOARSeverity["MEDIUM"] = 2] = "MEDIUM";
  XSOARSeverity[XSOARSeverity["HIGH"] = 3] = "HIGH";
  XSOARSeverity[XSOARSeverity["CRITICAL"] = 4] = "CRITICAL";
  return XSOARSeverity;
}({});