"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.OpenAiProviderType = exports.OPENAI_TITLE = exports.OPENAI_LEGACY_COMPLETION_URL = exports.OPENAI_CONNECTOR_ID = exports.OPENAI_CHAT_URL = exports.DEFAULT_TIMEOUT_MS = exports.DEFAULT_OPENAI_MODEL = exports.AZURE_OPENAI_COMPLETIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = exports.AZURE_OPENAI_CHAT_URL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPENAI_TITLE = exports.OPENAI_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.connectorTypeTitle', {
  defaultMessage: 'OpenAI'
});
const OPENAI_CONNECTOR_ID = exports.OPENAI_CONNECTOR_ID = '.gen-ai';
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  SUB_ACTION["INVOKE_ASYNC_ITERATOR"] = "invokeAsyncIterator";
  SUB_ACTION["STREAM"] = "stream";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
  return SUB_ACTION;
}({});
let OpenAiProviderType = exports.OpenAiProviderType = /*#__PURE__*/function (OpenAiProviderType) {
  OpenAiProviderType["OpenAi"] = "OpenAI";
  OpenAiProviderType["AzureAi"] = "Azure OpenAI";
  OpenAiProviderType["Other"] = "Other";
  return OpenAiProviderType;
}({});
const DEFAULT_TIMEOUT_MS = exports.DEFAULT_TIMEOUT_MS = 120000;
const DEFAULT_OPENAI_MODEL = exports.DEFAULT_OPENAI_MODEL = 'gpt-4.1';
const OPENAI_CHAT_URL = exports.OPENAI_CHAT_URL = 'https://api.openai.com/v1/chat/completions';
const OPENAI_LEGACY_COMPLETION_URL = exports.OPENAI_LEGACY_COMPLETION_URL = 'https://api.openai.com/v1/completions';
const AZURE_OPENAI_CHAT_URL = exports.AZURE_OPENAI_CHAT_URL = '/openai/deployments/{deployment-id}/chat/completions?api-version={api-version}';
const AZURE_OPENAI_COMPLETIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_URL = '/openai/deployments/{deployment-id}/completions?api-version={api-version}';
const AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = exports.AZURE_OPENAI_COMPLETIONS_EXTENSIONS_URL = '/openai/deployments/{deployment-id}/extensions/chat/completions?api-version={api-version}';