"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "INDEX_THRESHOLD_ID", {
  enumerable: true,
  get: function () {
    return _rule_type.ID;
  }
});
exports.plugin = exports.configSchema = exports.config = void 0;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _rule_type = require("./rule_types/index_threshold/rule_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const configSchema = exports.configSchema = _configSchema.schema.object({});
const config = exports.config = {
  exposeToBrowser: {},
  schema: configSchema,
  deprecations: () => [(settings, fromPath, addDeprecation) => {
    const stackAlerts = (0, _lodash.get)(settings, fromPath);
    if ((stackAlerts === null || stackAlerts === void 0 ? void 0 : stackAlerts.enabled) === false || (stackAlerts === null || stackAlerts === void 0 ? void 0 : stackAlerts.enabled) === true) {
      addDeprecation({
        level: 'critical',
        configPath: 'xpack.stack_alerts.enabled',
        message: `"xpack.stack_alerts.enabled" is deprecated. The ability to disable this plugin will be removed in 8.0.0.`,
        correctiveActions: {
          manualSteps: [`Remove "xpack.stack_alerts.enabled" from your kibana configs.`]
        }
      });
    }
  }]
};
const plugin = async ctx => {
  const {
    AlertingBuiltinsPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new AlertingBuiltinsPlugin(ctx);
};
exports.plugin = plugin;