"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleApiError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleApiError = (error, deps) => {
  var _error$body$message, _error$body;
  const {
    logger,
    toasts
  } = deps;
  const message = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.toString();
  logger.error(message);
  logger.error(error);
  toasts.addError(error, {
    title: message
  });
};
exports.handleApiError = handleApiError;