"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSpaceContentTab = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _handle_api_error = require("./handle_api_error");
var _provider = require("./provider");
var _common = require("../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditSpaceContentTab = ({
  space
}) => {
  const {
    id: spaceId
  } = space;
  const {
    spacesManager,
    serverBasePath,
    logger,
    notifications
  } = (0, _provider.useEditSpaceServices)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [items, setItems] = (0, _react.useState)(null);
  const columns = [{
    field: 'type',
    name: 'Type',
    render: (_value, item) => {
      const {
        icon,
        displayName
      } = item;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: icon !== null && icon !== void 0 ? icon : 'gear',
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }, (0, _lodash.capitalize)(displayName)));
    }
  }, {
    field: 'count',
    name: 'Count',
    render: (value, item) => {
      const uriComponent = encodeURIComponent(`/app/management/kibana/objects?initialQuery=type:(${item.type})`);
      const href = (0, _common.addSpaceIdToPath)(serverBasePath, space.id, `${_common.ENTER_SPACE_PATH}?next=${uriComponent}`);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: href
      }, value);
    }
  }];
  const getRowProps = item => {
    const {
      type
    } = item;
    return {
      'data-test-subj': `space-content-row-${type}`,
      onClick: () => {}
    };
  };
  const getCellProps = (item, column) => {
    const {
      type
    } = item;
    const {
      field
    } = column;
    return {
      'data-test-subj': `space-content-cell-${type}-${String(field)}`,
      textOnly: true
    };
  };
  (0, _react.useEffect)(() => {
    const getItems = async () => {
      const result = await spacesManager.getContentForSpace(spaceId);
      const {
        summary
      } = result;
      setItems(summary);
      setIsLoading(false);
    };
    getItems().catch(error => {
      (0, _handle_api_error.handleApiError)(error, {
        logger,
        toasts: notifications.toasts
      });
    });
  }, [spaceId, spacesManager, logger, notifications.toasts]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": "editSpaceContentTabLoadingIndicator"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    })));
  }
  if (!items) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.editSpaceContent.heading",
    defaultMessage: "All Kibana objects that are associated with this space."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "editSpaceContentTab",
    tableCaption: _i18n.i18n.translate('xpack.spaces.management.editSpaceContent.listTableCaption', {
      defaultMessage: 'List of saved object content within the space'
    }),
    items: items,
    rowHeader: "type",
    columns: columns,
    rowProps: getRowProps,
    cellProps: getCellProps
  })));
};
exports.EditSpaceContentTab = EditSpaceContentTab;