"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _feature_utils = require("../../lib/feature_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeatureTable extends _react.Component {
  constructor(props) {
    super(props);
    // features are static for the lifetime of the page, so this is safe to do here in a non-reactive manner
    (0, _defineProperty2.default)(this, "featureCategories", new Map());
    (0, _defineProperty2.default)(this, "onChange", featureId => e => {
      const updatedSpace = {
        ...this.props.space
      };
      let disabledFeatures = updatedSpace.disabledFeatures || [];
      const isFeatureEnabled = e.target.checked;
      if (isFeatureEnabled) {
        disabledFeatures = disabledFeatures.filter(feature => feature !== featureId);
      } else {
        disabledFeatures = _lodash.default.uniq([...disabledFeatures, featureId]);
      }
      updatedSpace.disabledFeatures = disabledFeatures;
      this.props.onChange(updatedSpace);
    });
    (0, _defineProperty2.default)(this, "getAllFeatureIds", () => [...this.featureCategories.values()].flat().map(feature => feature.id));
    (0, _defineProperty2.default)(this, "hideAll", () => {
      this.setFeaturesVisibility(this.getAllFeatureIds(), false);
    });
    (0, _defineProperty2.default)(this, "showAll", () => {
      this.setFeaturesVisibility(this.getAllFeatureIds(), true);
    });
    (0, _defineProperty2.default)(this, "setFeaturesVisibility", (features, visible) => {
      const updatedSpace = {
        ...this.props.space
      };
      if (visible) {
        var _updatedSpace$disable;
        updatedSpace.disabledFeatures = ((_updatedSpace$disable = updatedSpace.disabledFeatures) !== null && _updatedSpace$disable !== void 0 ? _updatedSpace$disable : []).filter(df => !features.includes(df));
      } else {
        var _updatedSpace$disable2;
        updatedSpace.disabledFeatures = Array.from(new Set([...((_updatedSpace$disable2 = updatedSpace.disabledFeatures) !== null && _updatedSpace$disable2 !== void 0 ? _updatedSpace$disable2 : []), ...features]));
      }
      this.props.onChange(updatedSpace);
    });
    (0, _defineProperty2.default)(this, "getCategoryHelpText", category => {
      if (category.id === 'management') {
        return _i18n.i18n.translate('xpack.spaces.management.managementCategoryHelpText', {
          defaultMessage: 'Access to Stack Management is determined by your privileges, and cannot be hidden by Spaces.'
        });
      }
    });
    props.features.forEach(feature => {
      if (!this.featureCategories.has(feature.category.id)) {
        this.featureCategories.set(feature.category.id, []);
      }
      this.featureCategories.get(feature.category.id).push(feature);
    });
  }
  render() {
    const {
      space
    } = this.props;
    const accordions = [];
    this.featureCategories.forEach(featuresInCategory => {
      var _category$order;
      const {
        category
      } = featuresInCategory[0];
      const featureCount = featuresInCategory.length;
      const enabledCount = (0, _feature_utils.getEnabledFeatures)(featuresInCategory, space).length;
      const canExpandCategory = featuresInCategory.length > 1;
      const checkboxProps = {
        id: `featureCategoryCheckbox_${category.id}`,
        indeterminate: enabledCount > 0 && enabledCount < featureCount,
        checked: featureCount === enabledCount,
        ['aria-label']: _i18n.i18n.translate('xpack.spaces.management.enabledFeatures.featureCategoryButtonLabel', {
          defaultMessage: 'Category toggle'
        }),
        onClick: e => {
          // Clicking the checkbox should not cause the accordion to expand.
          // Stopping event propagation ensures this.
          e.stopPropagation();
        },
        onChange: e => {
          this.setFeaturesVisibility(featuresInCategory.map(f => f.id), e.target.checked);
        }
      };
      const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": `featureCategoryButton_${category.id}`,
        alignItems: "center",
        responsive: false,
        gutterSize: "s",
        onClick: () => {
          if (!canExpandCategory) {
            const isChecked = enabledCount > 0;
            this.setFeaturesVisibility(featuresInCategory.map(f => f.id), !isChecked);
          }
        }
      }, category.euiIconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: category.euiIconType
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("h4", null, category.label))));
      const label = _i18n.i18n.translate('xpack.spaces.management.featureAccordionSwitchLabel', {
        defaultMessage: '{enabledCount}/{featureCount} features visible',
        values: {
          enabledCount,
          featureCount
        }
      });
      const extraAction = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "aria-hidden": "true",
        color: "subdued"
      }, label);
      const helpText = this.getCategoryHelpText(category);
      const accordion = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: category.id,
        alignItems: "baseline",
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, (0, _extends2.default)({}, checkboxProps, {
        "data-test-subj": `featureCategoryCheckbox_${category.id}`
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: `featureCategory_${category.id}`,
        "data-test-subj": `featureCategory_${category.id}`,
        arrowDisplay: canExpandCategory ? 'right' : 'none',
        forceState: canExpandCategory ? undefined : 'closed',
        buttonContent: buttonContent,
        extraAction: canExpandCategory ? extraAction : undefined
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), helpText && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "info",
        size: "s"
      }, helpText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      })), featuresInCategory.map(feature => {
        const featureChecked = !(space.disabledFeatures && space.disabledFeatures.includes(feature.id));
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          key: `${feature.id}-toggle`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
          id: `featureCheckbox_${feature.id}`,
          "data-test-subj": `featureCheckbox_${feature.id}`,
          checked: featureChecked,
          onChange: this.onChange(feature.id),
          label: feature.name
        })));
      }))));
      accordions.push({
        order: (_category$order = category.order) !== null && _category$order !== void 0 ? _category$order : Number.MAX_SAFE_INTEGER,
        element: accordion
      });
    });
    accordions.sort((a1, a2) => a1.order - a2.order);
    const featureCount = this.props.features.length;
    const enabledCount = (0, _feature_utils.getEnabledFeatures)(this.props.features, this.props.space).length;
    const controls = [];
    if (enabledCount < featureCount) {
      controls.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => this.showAll(),
        size: "xs",
        "data-test-subj": "showAllFeaturesLink"
      }, _i18n.i18n.translate('xpack.spaces.management.selectAllFeaturesLink', {
        defaultMessage: 'Show all'
      })));
    }
    if (enabledCount > 0) {
      controls.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => this.hideAll(),
        size: "xs",
        "data-test-subj": "hideAllFeaturesLink"
      }, _i18n.i18n.translate('xpack.spaces.management.deselectAllFeaturesLink', {
        defaultMessage: 'Hide all'
      })));
    }
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.spaces.management.featureVisibilityTitle', {
      defaultMessage: 'Feature visibility'
    })))), controls.map((control, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: idx
    }, control))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), accordions.flatMap((a, idx) => [a.element, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      key: `accordion-hr-${idx}`,
      margin: "m"
    })]));
  }
}
exports.FeatureTable = FeatureTable;