"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabFailures = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabFailures = ({
  indexFailures,
  snapshotState
}) => {
  if (!indexFailures.length) {
    // If the snapshot is in progress then we still might encounter errors later.
    if (snapshotState === _constants.SNAPSHOT_STATE.IN_PROGRESS) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.snapshotIsBeingCreatedMessage",
        defaultMessage: "Snapshot is being created."
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.noIndexFailuresMessage",
        defaultMessage: "All indices were stored successfully."
      });
    }
  }
  return indexFailures.map((indexObject, count) => {
    const {
      index,
      failures
    } = indexObject;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index,
      "data-test-subj": "indexFailure"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      "data-test-subj": "index"
    }, /*#__PURE__*/_react.default.createElement("h3", null, index)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), failures.map((failure, failuresCount) => {
      const {
        status,
        reason,
        shard_id: shardId
      } = failure;
      return /*#__PURE__*/_react.default.createElement("div", {
        key: `${shardId}${reason}`,
        "data-test-subj": "failure"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "data-test-subj": "shard"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.snapshotDetails.failureShardTitle",
        defaultMessage: "Shard {shardId}",
        values: {
          shardId
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        "data-test-subj": "reason",
        language: "text"
      }, `${status}: ${reason}`), failuresCount < failures.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }) : undefined);
    }), count < indexFailures.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }) : undefined);
  });
};
exports.TabFailures = TabFailures;