"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("../../../../../../common");
var _components = require("../../../../components");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _text = require("../../../../services/text");
var _navigation = require("../../../../services/navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryTable = ({
  repositories,
  managedRepository,
  reload,
  openRepositoryDetailsUrl,
  onRepositoryDeleted
}) => {
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: i18n.translate('xpack.snapshotRestore.repositoryList.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    truncateText: true,
    sortable: true,
    render: name => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, openRepositoryDetailsUrl(name), () => uiMetricService.trackUiMetric(_constants.UIM_REPOSITORY_SHOW_DETAILS_CLICK)), {
        "data-test-subj": "repositoryLink"
      }), name), "\xA0\xA0", managedRepository === name ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryList.table.managedRepositoryBadgeLabel",
          defaultMessage: "This is a managed repository"
        }),
        position: "right"
      }) : null);
    }
  }, {
    field: 'type',
    name: i18n.translate('xpack.snapshotRestore.repositoryList.table.typeColumnTitle', {
      defaultMessage: 'Type'
    }),
    truncateText: true,
    sortable: true,
    render: (type, repository) => {
      if (type === _common.REPOSITORY_TYPES.source) {
        return _text.textService.getRepositoryTypeName(type, repository.settings.delegateType);
      }
      return _text.textService.getRepositoryTypeName(type);
    }
  }, {
    field: 'actions',
    name: i18n.translate('xpack.snapshotRestore.repositoryList.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: ({
        name
      }) => {
        const label = i18n.translate('xpack.snapshotRestore.repositoryList.table.actionEditTooltip', {
          defaultMessage: 'Edit'
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: label
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
          "aria-label": i18n.translate('xpack.snapshotRestore.repositoryList.table.actionEditAriaLabel', {
            defaultMessage: 'Edit repository `{name}`',
            values: {
              name
            }
          }),
          iconType: "pencil",
          color: "primary"
        }, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToEditRepository)(name)), {
          "data-test-subj": "editRepositoryButton"
        })));
      }
    }, {
      render: ({
        name
      }) => {
        return /*#__PURE__*/_react.default.createElement(_components.RepositoryDeleteProvider, null, deleteRepositoryPrompt => {
          const label = name !== managedRepository ? i18n.translate('xpack.snapshotRestore.repositoryList.table.actionRemoveTooltip', {
            defaultMessage: 'Remove'
          }) : i18n.translate('xpack.snapshotRestore.repositoryList.table.deleteManagedRepositoryTooltip', {
            defaultMessage: 'You cannot delete a managed repository.'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.repositoryList.table.actionRemoveAriaLabel', {
              defaultMessage: 'Remove repository `{name}`',
              values: {
                name
              }
            }),
            iconType: "trash",
            color: "danger",
            "data-test-subj": "deleteRepositoryButton",
            onClick: () => deleteRepositoryPrompt([name], onRepositoryDeleted),
            isDisabled: Boolean(name === managedRepository)
          }));
        });
      }
    }],
    width: '100px'
  }];
  const sorting = {
    sort: {
      field: 'name',
      direction: 'asc'
    }
  };
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [10, 20, 50]
  };
  const selection = {
    onSelectionChange: newSelectedItems => setSelectedItems(newSelectedItems),
    selectable: ({
      name
    }) => Boolean(name !== managedRepository),
    selectableMessage: selectable => {
      if (!selectable) {
        return i18n.translate('xpack.snapshotRestore.repositoryList.table.deleteManagedRepositoryTooltip', {
          defaultMessage: 'You cannot delete a managed repository.'
        });
      }
      return '';
    }
  };
  const search = {
    toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.RepositoryDeleteProvider, null, deleteRepositoryPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: () => deleteRepositoryPrompt(selectedItems.map(repository => repository.name), onRepositoryDeleted),
        color: "danger",
        "data-test-subj": "srRepositoryListBulkDeleteActionButton"
      }, selectedItems.length === 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryList.table.deleteSingleRepositoryButton",
        defaultMessage: "Remove repository"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryList.table.deleteMultipleRepositoriesButton",
        defaultMessage: "Remove repositories"
      }));
    }) : undefined,
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "reloadButton",
      color: "success",
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "reloadButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryList.table.reloadRepositoriesButton",
      defaultMessage: "Reload"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      key: "registerRepo"
    }, (0, _public.reactRouterNavigate)(history,
    // @ts-expect-error
    (0, _navigation.linkToAddRepository)(name)), {
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "registerRepositoryButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryList.addRepositoryButtonLabel",
      defaultMessage: "Register repository"
    }))],
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'type',
      name: i18n.translate('xpack.snapshotRestore.repositoryList.table.typeFilterLabel', {
        defaultMessage: 'Type'
      }),
      multiSelect: false,
      options: Object.keys(repositories.reduce((typeMap, repository) => {
        typeMap[repository.type] = true;
        return typeMap;
      }, {})).map(type => {
        return {
          value: type,
          view: _text.textService.getRepositoryTypeName(type)
        };
      })
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: repositories,
    itemId: "name",
    columns: columns,
    search: search,
    sorting: sorting,
    selection: selection,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: (item, field) => ({
      'data-test-subj': `${field.name}_cell`
    }),
    "data-test-subj": "repositoryTable"
  });
};
exports.RepositoryTable = RepositoryTable;