"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _http = require("../../../../services/http");
var _text = require("../../../../services/text");
var _navigation = require("../../../../services/navigation");
var _common = require("../../../../../../common");
var _components = require("../../../../components");
var _type_details = require("./type_details");
var _type_to_doc_url = require("../../../../lib/type_to_doc_url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryDetails = ({
  repositoryName,
  onClose,
  onRepositoryDeleted
}) => {
  const {
    i18n,
    history
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const {
    error,
    data: repositoryDetails
  } = (0, _http.useLoadRepository)(repositoryName);
  const [verification, setVerification] = (0, _react.useState)(undefined);
  const [cleanup, setCleanup] = (0, _react.useState)(undefined);
  const [isLoadingVerification, setIsLoadingVerification] = (0, _react.useState)(false);
  const [isLoadingCleanup, setIsLoadingCleanup] = (0, _react.useState)(false);
  const verifyRepository = async () => {
    setIsLoadingVerification(true);
    const {
      data
    } = await (0, _http.verifyRepository)(repositoryName);
    setVerification(data.verification);
    setIsLoadingVerification(false);
  };
  const cleanupRepository = async () => {
    setIsLoadingCleanup(true);
    const {
      data
    } = await (0, _http.cleanupRepository)(repositoryName);
    setCleanup(data.cleanup);
    setIsLoadingCleanup(false);
  };

  // Reset verification state and cleanup when repository name changes, either from adjust URL or clicking
  // into a different repository in table list.
  (0, _react.useEffect)(() => {
    setVerification(undefined);
    setIsLoadingVerification(false);
    setCleanup(undefined);
    setIsLoadingCleanup(false);
  }, [repositoryName]);
  const renderBody = () => {
    if (repositoryDetails) {
      return renderRepository();
    }
    if (error) {
      return renderError();
    }
    return renderLoading();
  };
  const renderLoading = () => {
    return /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.loadingRepositoryDescription",
      defaultMessage: "Loading repository\u2026"
    }));
  };
  const renderError = () => {
    const notFound = error.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.repositoryDetails.repositoryNotFoundErrorMessage', {
          defaultMessage: `The repository ''{name}'' does not exist.`,
          values: {
            name: repositoryName
          }
        })
      }
    } : error;
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.loadingRepositoryErrorTitle",
        defaultMessage: "Error loading repository"
      }),
      error: errorObject
    });
  };
  const renderSnapshotCount = () => {
    const {
      snapshots
    } = repositoryDetails;
    if (!Number.isInteger(snapshots.count)) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.noSnapshotInformationDescription",
        defaultMessage: "No snapshot information"
      });
    }
    if (snapshots.count === 0) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.zeroSnapshotsDescription",
        defaultMessage: "Repository has no snapshots"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshots)(repositoryName)), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.snapshotsDescription",
      defaultMessage: "{count} {count, plural, one {snapshot} other {snapshots}} found",
      values: {
        count: snapshots.count
      }
    }));
  };
  const renderRepository = () => {
    const {
      repository,
      isManagedRepository
    } = repositoryDetails;
    if (!repository) {
      return null;
    }
    const {
      type
    } = repository;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isManagedRepository ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning",
      iconType: "info",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.managedRepositoryWarningTitle",
        defaultMessage: "This is a managed repository used by other systems. Any changes you make might affect how these systems operate."
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.typeTitle",
      defaultMessage: "Repository type"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "repositoryType"
    }, type === _common.REPOSITORY_TYPES.source ? _text.textService.getRepositoryTypeName(type, repository.settings.delegateType) : _text.textService.getRepositoryTypeName(type))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: (0, _type_to_doc_url.getRepositoryTypeDocUrl)(docLinks, type),
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.repositoryTypeDocLink",
      defaultMessage: "Repository docs"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.snapshotsTitle",
      defaultMessage: "Snapshots"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "snapshotCount"
    }, renderSnapshotCount()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_type_details.TypeDetails, {
      repository: repository
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), renderVerification(), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), renderCleanup());
  };
  const renderVerification = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.verificationTitle",
    defaultMessage: "Verification status"
  }))), verification ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_components.RepositoryVerificationBadge, {
    verificationResults: verification
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.verificationDetailsTitle",
    defaultMessage: "Details"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), verification ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    "data-test-subj": "verificationCodeBlock"
  }, JSON.stringify(verification.valid ? verification.response : verification.error, null, 2)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: verifyRepository,
    color: "primary",
    isLoading: isLoadingVerification
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.verifyButtonLabel",
    defaultMessage: "Verify repository"
  }))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: verifyRepository,
    color: "primary",
    isLoading: isLoadingVerification,
    "data-test-subj": "verifyRepositoryButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.verifyButtonLabel",
    defaultMessage: "Verify repository"
  }))));
  const renderCleanup = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.cleanupTitle",
    defaultMessage: "Repository cleanup"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.cleanupRepositoryMessage",
    defaultMessage: "You can clean up a repository to delete any unreferenced data from a snapshot. This may provide storage space savings. Note: If you regularly delete snapshots, this functionality will likely not be as beneficial and should be used less frequently."
  }))), cleanup ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), cleanup.cleaned ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.cleanupDetailsTitle",
    defaultMessage: "Details"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    "data-test-subj": "cleanupCodeBlock"
  }, JSON.stringify(cleanup.response, null, 2))) : /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.cleanupErrorTitle",
      defaultMessage: "Error cleaning repository"
    }),
    error: cleanup.error,
    "data-test-subj": "cleanupError"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: cleanupRepository,
    color: "primary",
    isLoading: isLoadingCleanup,
    "data-test-subj": "cleanupRepositoryButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.cleanupButtonLabel",
    defaultMessage: "Clean up repository"
  })));
  const renderFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: onClose,
      "data-test-subj": "srRepositoryDetailsFlyoutCloseButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.closeButtonLabel",
      defaultMessage: "Close"
    }))), repositoryDetails ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.RepositoryDeleteProvider, null, deleteRepositoryPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        color: "danger",
        "data-test-subj": "srRepositoryDetailsDeleteActionButton",
        onClick: () => deleteRepositoryPrompt([repositoryName], onRepositoryDeleted),
        isDisabled: repositoryDetails.isManagedRepository,
        title: repositoryDetails.isManagedRepository ? i18n.translate('xpack.snapshotRestore.repositoryDetails.removeManagedRepositoryButtonTitle', {
          defaultMessage: 'You cannot delete a managed repository.'
        }) : undefined
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.removeButtonLabel",
        defaultMessage: "Remove"
      }));
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToEditRepository)(repositoryName)), {
      fill: true,
      color: "primary"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.editButtonLabel",
      defaultMessage: "Edit"
    }))))) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "repositoryDetail",
    "aria-labelledby": "srRepositoryDetailsFlyoutTitle",
    size: "m",
    maxWidth: 550
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "srRepositoryDetailsFlyoutTitle",
    "data-test-subj": "title"
  }, repositoryName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, renderBody()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, renderFooter()));
};
exports.RepositoryDetails = RepositoryDetails;