"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotStepReview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lib = require("../../../../../common/lib");
var _app_context = require("../../../app_context");
var _collapsible_lists = require("../../collapsible_lists");
var _summaries = require("../../summaries");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RestoreSnapshotStepReview = ({
  restoreSettings,
  updateCurrentStep
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    indices: restoreIndices,
    renamePattern,
    renameReplacement,
    partial,
    includeGlobalState,
    featureStates,
    ignoreIndexSettings
  } = restoreSettings;
  const serializedRestoreSettings = (0, _lib.serializeRestoreSettings)(restoreSettings);
  const {
    index_settings: serializedIndexSettings
  } = serializedRestoreSettings;
  const renderSummaryTab = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.sectionLogisticsTitle",
    defaultMessage: "Logistics"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.editStepTooltip",
      defaultMessage: "Edit"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => updateCurrentStep(1)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "pencil"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.dataStreamsAndIndicesLabel",
    defaultMessage: "Data streams and indices"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_collapsible_lists.CollapsibleIndicesList, {
    indices: restoreIndices
  }))))), renamePattern || renameReplacement ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.sectionRenameTitle",
    defaultMessage: "Rename indices"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, renamePattern ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.renamePatternLabel",
    defaultMessage: "Capture pattern"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, renamePattern))) : null, renameReplacement ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.renameReplacementLabel",
    defaultMessage: "Replacement pattern"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, renameReplacement))) : null)) : null, featureStates !== undefined || includeGlobalState !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, includeGlobalState !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.includeGlobalStateLabel",
    defaultMessage: "Restore global state"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, includeGlobalState === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.includeGlobalStateFalseValue",
    defaultMessage: "No"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.includeGlobalStateTrueValue",
    defaultMessage: "Yes"
  })))) : null, featureStates !== undefined ? /*#__PURE__*/_react.default.createElement(_summaries.PolicyFeatureStatesSummary, {
    featureStates: featureStates
  }) : null) : null, partial !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.partialLabel",
    defaultMessage: "Partial restore"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, partial ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.partialTrueValue",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.partialFalseValue",
    defaultMessage: "No"
  }))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.sectionSettingsTitle",
    defaultMessage: "Index settings"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.editStepTooltip",
      defaultMessage: "Edit"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => updateCurrentStep(2)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "pencil"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), serializedIndexSettings || ignoreIndexSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, serializedIndexSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.indexSettingsLabel",
    defaultMessage: "Modify"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "none"
  }, Object.entries(serializedIndexSettings).map(([setting, value]) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: setting
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, setting))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, " ", value))))))))) : null, ignoreIndexSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.ignoreIndexSettingsLabel",
    defaultMessage: "Reset"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, ignoreIndexSettings.map(setting => /*#__PURE__*/_react.default.createElement("li", {
    key: setting
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, setting))))))))) : null) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReview.summaryTab.noSettingsValue",
    defaultMessage: "No index setting modifications"
  }));
  const renderJsonTab = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "m",
    language: "json",
    isCopyable: true,
    "aria-label": i18n.translate('xpack.snapshotRestore.restoreForm.stepReview.jsonTab.jsonAriaLabel', {
      defaultMessage: 'Restore settings to be executed'
    })
  }, JSON.stringify(serializedRestoreSettings, null, 2)));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "reviewSnapshotTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepReviewTitle",
    defaultMessage: "Review restore details"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: [{
      id: 'summary',
      name: i18n.translate('xpack.snapshotRestore.restoreForm.stepReview.summaryTabTitle', {
        defaultMessage: 'Summary'
      }),
      content: renderSummaryTab()
    }, {
      id: 'json',
      name: i18n.translate('xpack.snapshotRestore.restoreForm.stepReview.jsonTabTitle', {
        defaultMessage: 'JSON'
      }),
      content: renderJsonTab()
    }]
  }));
};
exports.RestoreSnapshotStepReview = RestoreSnapshotStepReview;