"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SectionLoading = exports.PageLoading = exports.InlineLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InlineLoading = ({
  children,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, rest, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, children))));
};
exports.InlineLoading = InlineLoading;
const SectionLoading = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, children),
    "data-test-subj": "sectionLoading"
  });
};

/*
 * Loading component used for full page loads.
 * For tabbed sections, or within the context of a wizard,
 * the <SectionLoading/> component may be more appropriate
 */
exports.SectionLoading = SectionLoading;
const PageLoading = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, children),
    "data-test-subj": "sectionLoading"
  });
};
exports.PageLoading = PageLoading;