"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldSuppressInstanceId = shouldSuppressInstanceId;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function shouldSuppressInstanceId(results, instanceId) {
  return results.reduce((acc, res) => {
    if (acc === true) return acc;
    if (res.suppressAll === true) return true;
    if (instanceId === _sloSchema.ALL_VALUE && res.instanceIdsToSuppress.length > 0) return true;
    return res.instanceIdsToSuppress.length > 0 && res.instanceIdsToSuppress.some(id => id === instanceId);
  }, false);
}