"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloRemoteBadge = SloRemoteBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_space = require("../../../../hooks/use_space");
var _remote_slo_urls = require("../../../../utils/slo/remote_slo_urls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloRemoteBadge({
  slo
}) {
  const spaceId = (0, _use_space.useSpace)();
  if (!slo.remote) {
    return null;
  }
  const sloDetailsUrl = (0, _remote_slo_urls.createRemoteSloDetailsUrl)(slo, spaceId);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: slo.remote.kibanaUrl,
    title: slo.remote.remoteName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    href: sloDetailsUrl,
    target: "_blank",
    onMouseDown: e => {
      e.stopPropagation();
    }
  }, _i18n.i18n.translate('xpack.slo.sloCardItemBadges.remoteBadgeLabel', {
    defaultMessage: 'Remote'
  }))));
}