"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSettings = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../common/constants");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSettings = () => {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isLoading,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['getSloSettings'],
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch('GET /internal/slo/settings', {
          signal
        });
      } catch (error) {
        return defaultSettings;
      }
    },
    keepPreviousData: true,
    refetchOnWindowFocus: false
  });
  return {
    isLoading,
    data
  };
};
exports.useGetSettings = useGetSettings;
const defaultSettings = {
  useAllRemoteClusters: false,
  selectedRemoteClusters: [],
  staleThresholdInHours: _constants.DEFAULT_STALE_SLO_THRESHOLD_HOURS
};