"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloHealthCallout = SloHealthCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
var _use_fetch_slo_health = require("../../../hooks/use_fetch_slo_health");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloHealthCallout({
  slo
}) {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    isLoading,
    isError,
    data
  } = (0, _use_fetch_slo_health.useFetchSloHealth)({
    list: [slo]
  });
  if (isLoading || isError || data === undefined || (data === null || data === void 0 ? void 0 : data.length) !== 1) {
    return null;
  }
  const health = data[0].health;
  if (health.overall === 'healthy') {
    return null;
  }
  const count = health.rollup === 'unhealthy' && health.summary === 'unhealthy' ? 2 : 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.title', {
      defaultMessage: 'This SLO has issues with its transforms'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.healthCallout.description",
    defaultMessage: "The following {count, plural, one {transform is} other {transforms are} } in an unhealthy state:",
    values: {
      count
    }
  }), /*#__PURE__*/_react.default.createElement("ul", null, health.rollup === 'unhealthy' && /*#__PURE__*/_react.default.createElement("li", null, (0, _constants.getSLOTransformId)(slo.id, slo.revision), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: (0, _constants.getSLOTransformId)(slo.id, slo.revision)
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sloSloHealthCalloutCopyButton",
    "aria-label": _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.copyToClipboard', {
      defaultMessage: 'Copy to clipboard'
    }),
    color: "text",
    iconType: "copy",
    onClick: copy
  }))), health.summary === 'unhealthy' && /*#__PURE__*/_react.default.createElement("li", null, (0, _constants.getSLOSummaryTransformId)(slo.id, slo.revision), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: (0, _constants.getSLOSummaryTransformId)(slo.id, slo.revision)
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sloSloHealthCalloutCopyButton",
    "aria-label": _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.copyToClipboard', {
      defaultMessage: 'Copy to clipboard'
    }),
    color: "text",
    iconType: "copy",
    onClick: copy
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloSloHealthCalloutInspectTransformButton",
    color: "danger",
    fill: true,
    href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/data/transform')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.healthCallout.buttonTransformLabel",
    defaultMessage: "Inspect transform"
  })))));
}