"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _common = require("@kbn/observability-plugin/common");
var _use_url_search_state = require("../pages/slos/hooks/use_url_search_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SloListLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.sloListLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      kqlQuery = ''
    }) => {
      const state = (0, _deepmerge.default)(_use_url_search_state.DEFAULT_STATE, {
        kqlQuery
      });
      return {
        app: 'slo',
        path: (0, _public.setStateToKbnUrl)(_use_url_search_state.SLO_LIST_SEARCH_URL_STORAGE_KEY, state, {
          useHash: false,
          storeInHashQuery: false
        }, '/'),
        state: {}
      };
    });
  }
}
exports.SloListLocatorDefinition = SloListLocatorDefinition;