"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateSlo = useUpdateSlo;
var _i18n = require("@kbn/i18n");
var _rison = require("@kbn/rison");
var _reactQuery = require("@tanstack/react-query");
var _paths = require("../../common/locators/paths");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUpdateSlo() {
  const {
    application: {
      navigateToUrl
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  return (0, _reactQuery.useMutation)(['updateSlo'], ({
    sloId,
    slo
  }) => {
    return sloClient.fetch('PUT /api/observability/slos/{id} 2023-10-31', {
      params: {
        path: {
          id: sloId
        },
        body: slo
      }
    });
  }, {
    onSuccess: (_data, {
      slo: {
        name
      }
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.update.successNotification', {
        defaultMessage: 'Successfully updated {name}',
        values: {
          name
        }
      }));
    },
    onError: (error, {
      slo,
      sloId
    }, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.update.errorNotification', {
          defaultMessage: 'Something went wrong when updating {name}',
          values: {
            name: slo.name
          }
        })
      });
      navigateToUrl(http.basePath.prepend(_paths.paths.sloEditWithEncodedForm(sloId, (0, _rison.encode)(slo))));
    }
  });
}