"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResetSlo = useResetSlo;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useResetSlo() {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  return (0, _reactQuery.useMutation)(['resetSlo'], ({
    id
  }) => {
    return sloClient.fetch('POST /api/observability/slos/{id}/_reset 2023-10-31', {
      params: {
        path: {
          id
        }
      }
    });
  }, {
    onError: (error, {
      name,
      id
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.slo.reset.errorNotification', {
          defaultMessage: 'Failed to reset {name} (id: {id})',
          values: {
            name,
            id
          }
        })
      });
    },
    onSuccess: (_data, {
      name,
      id
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.historicalSummaries(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.details(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.allDefinitions(),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.slo.reset.successNotification', {
        defaultMessage: '{name} reset successfully',
        values: {
          name
        }
      }));
    }
  });
}