"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetPreviewData = useGetPreviewData;
var _reactQuery = require("@tanstack/react-query");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetPreviewData({
  isValid,
  range,
  indicator,
  objective,
  groupings,
  remoteName,
  groupBy
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.preview({
      range,
      indicator,
      objective,
      groupings,
      remoteName,
      groupBy
    }),
    queryFn: async ({
      signal
    }) => {
      const response = await sloClient.fetch('POST /internal/observability/slos/_preview', {
        params: {
          body: {
            indicator,
            range: {
              from: range.from.toISOString(),
              to: range.to.toISOString()
            },
            groupings,
            remoteName,
            objective,
            groupBy
          }
        },
        signal
      });
      return response;
    },
    retry: false,
    refetchOnWindowFocus: false,
    enabled: isValid
  });
  return {
    data,
    isLoading,
    isInitialLoading,
    isSuccess,
    isError
  };
}