"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnableSlo = useEnableSlo;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEnableSlo() {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['enableSlo'], ({
    id
  }) => {
    try {
      return sloClient.fetch(`POST /api/observability/slos/{id}/enable 2023-10-31`, {
        params: {
          path: {
            id
          }
        }
      });
    } catch (error) {
      return Promise.reject(`Something went wrong: ${String(error)}`);
    }
  }, {
    onError: (error, {
      name
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.enable.errorNotification', {
          defaultMessage: 'Failed to enable {name}',
          values: {
            name
          }
        })
      });
    },
    onSuccess: (_data, {
      name
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.details(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.allDefinitions(),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.enable.successNotification', {
        defaultMessage: 'Enabled {name}',
        values: {
          name
        }
      }));
    }
  });
}