"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloPermissionsCallout = SloPermissionsCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_permissions = require("../../../hooks/use_permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloPermissionsCallout() {
  const {
    data: permissions,
    isLoading
  } = (0, _use_permissions.usePermissions)();
  if (isLoading) {
    return null;
  }
  if (permissions !== null && permissions !== void 0 && permissions.hasAllReadRequested || permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.slo.permissionsCallout.title', {
      defaultMessage: 'Insufficient Permissions'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.permissionsCallout.message",
    defaultMessage: "You do not have sufficient permissions to view or edit SLO definitions."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.permissionsCallout.minimumReadPermissionsRequired",
    defaultMessage: "In order to view SLO dashboards and details, you need at least the following permissions on your user's role:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.permissionsCallout.readSloPermission",
    defaultMessage: "'read' and 'view_index_metadata' permission on index pattern: .slo-observability.*"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.permissionsCallout.minimumManagePermissionsRequired",
    defaultMessage: "In order to create and manage SLO definitions, you need at least the following permissions on your user's role:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.permissionsCallout.writeSloPermission",
    defaultMessage: "'read', 'view_index_metadata', 'write' and 'manage' permission on index pattern: .slo-observability.*"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.permissionsCallout.readIndexPermission",
    defaultMessage: "'read' and 'view_index_metadata' index permissions on any index patterns you want to use for creating SLOs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "sloSloPermissionsCalloutReadTheDocumentationLink",
    href: "https://www.elastic.co/guide/en/observability/current/slo-privileges.html",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.slo.permissionsCallout.readDocumentation', {
    defaultMessage: 'Read the documentation for more details'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}