"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExportMenu = ({
  shareContext
}) => {
  return /*#__PURE__*/_react.default.createElement(_context.ShareProvider, {
    shareContext
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement((0, _i18nReact.injectI18n)(ExportMenuPopover))));
};
exports.ExportMenu = ExportMenu;
function LayoutOptionsSwitch({
  usePrintLayout,
  printLayoutChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.label",
      defaultMessage: "Print format"
    }))),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.helpText",
      defaultMessage: "Uses multiple pages, showing at most 2 visualizations per page "
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, usePrintLayout ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.selection.on",
      defaultMessage: "On"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.exportFlyoutContent.optimizeForPrinting.selection.off",
      defaultMessage: "Off"
    })),
    checked: usePrintLayout,
    onChange: printLayoutChange,
    "data-test-subj": "usePrintLayout"
  }))));
}
function ManagedFlyout({
  exportIntegration,
  intl,
  isDirty,
  onCloseFlyout,
  publicAPIEnabled,
  shareObjectTypeMeta,
  shareObjectType,
  shareObjectTypeAlias
}) {
  var _shareObjectTypeMeta$, _shareObjectTypeMeta$2, _exportIntegration$co;
  const [usePrintLayout, setPrintLayout] = (0, _react.useState)(false);
  const [isCreatingExport, setIsCreatingExport] = (0, _react.useState)(false);
  const getReport = (0, _react.useCallback)(async () => {
    try {
      setIsCreatingExport(true);
      await exportIntegration.config.generateAssetExport({
        intl,
        optimizedForPrinting: usePrintLayout
      });
    } finally {
      setIsCreatingExport(false);
      onCloseFlyout();
    }
  }, [exportIntegration.config, intl, onCloseFlyout, usePrintLayout]);
  const DraftModeCallout = (_shareObjectTypeMeta$ = shareObjectTypeMeta.config) === null || _shareObjectTypeMeta$ === void 0 ? void 0 : (_shareObjectTypeMeta$2 = _shareObjectTypeMeta$[exportIntegration.id]) === null || _shareObjectTypeMeta$2 === void 0 ? void 0 : _shareObjectTypeMeta$2.draftModeCallOut;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.export.flyoutTitle",
    defaultMessage: "Export {objectType} as {type}",
    values: {
      objectType: shareObjectTypeAlias !== null && shareObjectTypeAlias !== void 0 ? shareObjectTypeAlias : shareObjectType.toLocaleLowerCase(),
      type: exportIntegration.config.label
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, exportIntegration.config.renderLayoutOptionSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(LayoutOptionsSwitch, {
    usePrintLayout: usePrintLayout,
    printLayoutChange: evt => setPrintLayout(evt.target.checked)
  }))), /*#__PURE__*/_react.default.createElement(_react.Fragment, null, (exportIntegration === null || exportIntegration === void 0 ? void 0 : exportIntegration.config.copyAssetURIConfig) && publicAPIEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h4", null, exportIntegration.config.copyAssetURIConfig.headingText)),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, exportIntegration.config.copyAssetURIConfig.helpText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "exportAssetValue",
    css: {
      overflowWrap: 'break-word'
    },
    overflowHeight: 360,
    language: exportIntegration.config.copyAssetURIConfig.contentType,
    isCopyable: true,
    copyAriaLabel: _i18n.i18n.translate('share.export.copyPostURLAriaLabel', {
      defaultMessage: 'Copy export asset value'
    })
  }, exportIntegration.config.copyAssetURIConfig.generateAssetURIValue({
    intl,
    optimizedForPrinting: usePrintLayout
  }))))))), /*#__PURE__*/_react.default.createElement(_react.Fragment, null, exportIntegration.config.generateAssetComponent), /*#__PURE__*/_react.default.createElement(_react.Fragment, null, publicAPIEnabled && isDirty && DraftModeCallout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, DraftModeCallout)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "exportFlyoutCloseButton",
    onClick: onCloseFlyout
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.export.closeFlyoutButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: getReport,
    "data-test-subj": "generateReportButton",
    isLoading: isCreatingExport
  }, (_exportIntegration$co = exportIntegration.config.generateExportButtonLabel) !== null && _exportIntegration$co !== void 0 ? _exportIntegration$co : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.export.generateButtonLabel",
    defaultMessage: "Export {type}",
    values: {
      type: exportIntegration.config.label
    }
  }))))));
}
function ExportMenuPopover({
  intl
}) {
  const {
    onClose,
    anchorElement,
    shareMenuItems: exportIntegrations,
    isDirty,
    publicAPIEnabled,
    objectType,
    objectTypeAlias,
    objectTypeMeta
  } = (0, _context.useShareTypeContext)('integration', 'export');
  const {
    shareMenuItems: exportDerivatives
  } = (0, _context.useShareTypeContext)('integration', 'exportDerivatives');
  const availableExportDerivatives = (0, _react.useMemo)(() => exportDerivatives.filter(exportDerivative => exportDerivative.config.shouldRender({
    availableExportItems: exportIntegrations
  })), [exportDerivatives, exportIntegrations]);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const selectionOptions = (0, _react.useRef)({
    export: exportIntegrations,
    exportDerivatives
  });
  const [selectedMenuItemMeta, setSelectedMenuItemMeta] = (0, _react.useState)();
  const selectedMenuItem = (0, _react.useMemo)(() => {
    let result = null;
    if (!selectedMenuItemMeta) {
      return result;
    }
    selectionOptions.current[selectedMenuItemMeta.group].forEach(item => {
      if (item.id === selectedMenuItemMeta.id) {
        result = item;
      }
    });
    return result;
  }, [selectedMenuItemMeta]);
  const openFlyout = (0, _react.useCallback)(menuItem => {
    setSelectedMenuItemMeta({
      id: menuItem.id,
      group: menuItem.groupId
    });
    setIsFlyoutVisible(true);
  }, []);
  const exportIntegrationInteractionHandler = (0, _react.useCallback)(async menuItem => {
    if (!menuItem.config.copyAssetURIConfig && !menuItem.config.generateAssetComponent && menuItem.config.generateAssetExport) {
      await menuItem.config.generateAssetExport({
        intl,
        optimizedForPrinting: false
      }).finally(() => {
        onClose();
      });
    } else {
      openFlyout(menuItem);
    }
  }, [intl, onClose, openFlyout]);
  const flyoutRef = (0, _react.useRef)(null);
  const canSkipDisplayingPopover = (0, _react.useMemo)(() => {
    // when there is only one export share menu item, and no export derivatives registered,
    // we'd like to skip displaying the popover
    return exportIntegrations.length === 1 && !exportDerivatives.length;
  }, [exportIntegrations, exportDerivatives]);
  const flyoutOnCloseHandler = (0, _react.useCallback)(() => {
    setIsFlyoutVisible(false);
    if (canSkipDisplayingPopover) {
      onClose();
    }
  }, [onClose, canSkipDisplayingPopover]);
  (0, _react.useEffect)(() => {
    if (canSkipDisplayingPopover && !selectedMenuItemMeta) {
      exportIntegrationInteractionHandler(exportIntegrations[0]);
    }
  }, [exportIntegrationInteractionHandler, exportIntegrations, onClose, selectedMenuItemMeta, canSkipDisplayingPopover]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: !isFlyoutVisible && !canSkipDisplayingPopover,
    button: anchorElement,
    closePopover: onClose,
    panelPaddingSize: "s",
    panelProps: {
      'data-test-subj': 'exportPopoverPanel'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true
  }, exportIntegrations.map(menuItem => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: selectedMenuItem === null || selectedMenuItem === void 0 ? void 0 : selectedMenuItem.config.toolTipContent,
    key: menuItem.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: menuItem.config.icon,
    key: menuItem.id,
    label: menuItem.config.label,
    "data-test-subj": `exportMenuItem-${menuItem.config.label}`,
    isDisabled: menuItem.config.disabled,
    onClick: exportIntegrationInteractionHandler.bind(null, menuItem)
  })))), Boolean(availableExportDerivatives.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, availableExportDerivatives.map(exportDerivative => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: exportDerivative.id
    }, exportDerivative.config.label({
      openFlyout: openFlyout.bind(null, exportDerivative)
    }));
  })))), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({
    "data-test-subj": "exportItemDetailsFlyout",
    size: "s",
    onClose: flyoutOnCloseHandler,
    css: () => ({
      ['--euiFixedHeadersOffset']: 0,
      isolation: 'isolate' // ensures that tooltips within this flyout render as should
    }),
    ownFocus: true,
    maskProps: {
      headerZindexLocation: 'above'
    },
    ref: flyoutRef
  }, (selectedMenuItem === null || selectedMenuItem === void 0 ? void 0 : selectedMenuItem.groupId) === 'exportDerivatives' ? selectedMenuItem.config.flyoutSizing || {} : {}), /*#__PURE__*/_react.default.createElement(_react2.Global
  // @ts-expect-error -- we pass a z-index specifying important so we override the default z-index, so solve a known bug,
  // where when `headerZindexLocation` is set to `above`, the popover panel z-index is not high enough
  , {
    styles: {
      '.euiPopover__panel[data-popover-open="true"]': {
        zIndex: '7000 !important'
      }
    }
  }), selectedMenuItemMeta.group === 'export' ? /*#__PURE__*/_react.default.createElement(ManagedFlyout, {
    exportIntegration: selectedMenuItem,
    shareObjectType: objectType,
    shareObjectTypeAlias: objectTypeAlias,
    shareObjectTypeMeta: objectTypeMeta,
    isDirty: isDirty,
    publicAPIEnabled: publicAPIEnabled,
    intl: intl,
    onCloseFlyout: flyoutOnCloseHandler
  }) : selectedMenuItem === null || selectedMenuItem === void 0 ? void 0 : selectedMenuItem.config.flyoutContent({
    flyoutRef,
    closeFlyout: flyoutOnCloseHandler
  })));
}