"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyConnectorsPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../common/doc_links");
var _use_connector_types = require("../../hooks/api/use_connector_types");
var _use_create_connector = require("../../hooks/api/use_create_connector");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _use_connectors = require("../../hooks/api/use_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyConnectorsPrompt = () => {
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const {
    createConnector,
    isLoading
  } = (0, _use_create_connector.useCreateConnector)();
  const {
    data
  } = (0, _use_connectors.useConnectors)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const connectorsPath = assetBasePath + '/connectors.svg';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: connectorsPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.title', {
    defaultMessage: 'Create a connector'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.description', {
    defaultMessage: "To set up and deploy a connector you'll be working between the third-party data source, your terminal, and the Elasticsearch serverless UI. The high level process looks like this:"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.guideOneDescription', {
    defaultMessage: "Choose a data source you'd like to sync"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: connectorsPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectorsEmpty.guideTwoDescription",
    defaultMessage: "Deploy connector code on your own infrastructure by running from {source}, or using {docker}",
    values: {
      source: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "serverlessSearchEmptyConnectorsPromptSourceLink",
        href: _doc_links.docLinks.connectorsRunFromSource
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.sourceLabel', {
        defaultMessage: 'source'
      })),
      docker: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "serverlessSearchEmptyConnectorsPromptDockerLink",
        href: _doc_links.docLinks.connectorsRunWithDocker
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.dockerLabel', {
        defaultMessage: 'Docker'
      }))
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "sortRight"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: connectorsPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "sortRight"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "primary",
    size: "l",
    type: "logoElastic"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.guideThreeDescription', {
    defaultMessage: 'Enter access and connection details for your data source and run your first sync'
  }))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchEmptyConnectorsPromptCreateConnectorButton",
    disabled: !(data !== null && data !== void 0 && data.canManageConnectors),
    fill: true,
    iconType: "plusInCircleFilled",
    onClick: () => createConnector(),
    isLoading: isLoading
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.createConnector', {
    defaultMessage: 'Create connector'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.connectorsEmpty.availableConnectors', {
    defaultMessage: 'Available connectors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, connectorTypes.map(connectorType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: connectorType.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: connectorType.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    title: connectorType.name,
    id: connectorType.serviceType,
    type: connectorType.iconPath
  })))))));
};
exports.EmptyConnectorsPrompt = EmptyConnectorsPrompt;