"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServerTLSOptions = getServerTLSOptions;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Converts Kibana `SslConfig` into `TLSOptions` that are accepted by the Hapi server,
 * and by https.Server.setSecureContext()
 */
function getServerTLSOptions(ssl) {
  var _ssl$cipherSuites;
  if (!ssl.enabled) {
    return undefined;
  }
  return {
    ca: ssl.certificateAuthorities,
    cert: ssl.certificate,
    ciphers: (_ssl$cipherSuites = ssl.cipherSuites) === null || _ssl$cipherSuites === void 0 ? void 0 : _ssl$cipherSuites.join(':'),
    // We use the server's cipher order rather than the client's to prevent the BEAST attack.
    honorCipherOrder: true,
    key: ssl.key,
    passphrase: ssl.keyPassphrase,
    secureOptions: ssl.getSecureOptions ? ssl.getSecureOptions() : undefined,
    requestCert: ssl.requestCert,
    rejectUnauthorized: ssl.rejectUnauthorized
  };
}