"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIdsAndNamespaces = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIdsAndNamespaces = ({
  lists,
  showDetection,
  showEndpoint
}) => lists.filter(list => {
  if (showDetection) {
    return list.type === 'detection';
  } else if (showEndpoint) {
    return list.type === 'endpoint';
  } else {
    return true;
  }
}).reduce((acc, {
  listId,
  namespaceType
}) => ({
  ids: [...acc.ids, listId],
  namespaces: [...acc.namespaces, namespaceType]
}), {
  ids: [],
  namespaces: []
});
exports.getIdsAndNamespaces = getIdsAndNamespaces;