"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findExceptionListItemSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _default_namespace_array = require("../../common/default_namespace_array");
var _sort_field = require("../../common/sort_field");
var _sort_order = require("../../common/sort_order");
var _search = require("../../common/search");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findExceptionListItemSchema = exports.findExceptionListItemSchema = t.intersection([t.exact(t.type({
  list_id: _securitysolutionIoTsTypes.NonEmptyStringArray
})), t.exact(t.partial({
  filter: _securitysolutionIoTsTypes.EmptyStringArray,
  // defaults to an empty array [] if not set during decode
  namespace_type: _default_namespace_array.DefaultNamespaceArray,
  // defaults to ['single'] if not set during decode
  page: _securitysolutionIoTsTypes.StringToPositiveNumber,
  // defaults to undefined if not set during decode
  per_page: _securitysolutionIoTsTypes.StringToPositiveNumber,
  // defaults to undefined if not set during decode
  search: _search.search,
  sort_field: _sort_field.sort_field,
  // defaults to undefined if not set during decode
  sort_order: _sort_order.sort_order // defaults to undefined if not set during decode
}))]);

// This type is used after a decode since some things are defaults after a decode.