"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionListItemEntryOperatorEnum = exports.ExceptionListItemEntryOperator = exports.ExceptionListItemEntryNestedEntryItemInternal = exports.ExceptionListItemEntryNestedEntryItem = exports.ExceptionListItemEntryNested = exports.ExceptionListItemEntryMatchWildcard = exports.ExceptionListItemEntryMatchAny = exports.ExceptionListItemEntryMatch = exports.ExceptionListItemEntryList = exports.ExceptionListItemEntryInternal = exports.ExceptionListItemEntryExists = exports.ExceptionListItemEntryArray = exports.ExceptionListItemEntry = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _list_common = require("@kbn/securitysolution-lists-common/api/model/list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Exception List Item Entry Attributes
 *   version: not applicable
 */

const ExceptionListItemEntryOperator = exports.ExceptionListItemEntryOperator = _zod.z.enum(['excluded', 'included']);
const ExceptionListItemEntryOperatorEnum = exports.ExceptionListItemEntryOperatorEnum = ExceptionListItemEntryOperator.enum;
const ExceptionListItemEntryMatch = exports.ExceptionListItemEntryMatch = _zod.z.object({
  type: _zod.z.literal('match'),
  field: _primitives.NonEmptyString,
  value: _primitives.NonEmptyString,
  operator: ExceptionListItemEntryOperator
});
const ExceptionListItemEntryMatchAny = exports.ExceptionListItemEntryMatchAny = _zod.z.object({
  type: _zod.z.literal('match_any'),
  field: _primitives.NonEmptyString,
  value: _zod.z.array(_primitives.NonEmptyString).min(1),
  operator: ExceptionListItemEntryOperator
});
const ExceptionListItemEntryList = exports.ExceptionListItemEntryList = _zod.z.object({
  type: _zod.z.literal('list'),
  field: _primitives.NonEmptyString,
  list: _zod.z.object({
    id: _list_common.ListId,
    type: _list_common.ListType
  }),
  operator: ExceptionListItemEntryOperator
});
const ExceptionListItemEntryExists = exports.ExceptionListItemEntryExists = _zod.z.object({
  type: _zod.z.literal('exists'),
  field: _primitives.NonEmptyString,
  operator: ExceptionListItemEntryOperator
});
const ExceptionListItemEntryNestedEntryItemInternal = exports.ExceptionListItemEntryNestedEntryItemInternal = _zod.z.union([ExceptionListItemEntryMatch, ExceptionListItemEntryMatchAny, ExceptionListItemEntryExists]);
const ExceptionListItemEntryNestedEntryItem = exports.ExceptionListItemEntryNestedEntryItem = ExceptionListItemEntryNestedEntryItemInternal;
const ExceptionListItemEntryNested = exports.ExceptionListItemEntryNested = _zod.z.object({
  type: _zod.z.literal('nested'),
  field: _primitives.NonEmptyString,
  entries: _zod.z.array(ExceptionListItemEntryNestedEntryItem).min(1)
});
const ExceptionListItemEntryMatchWildcard = exports.ExceptionListItemEntryMatchWildcard = _zod.z.object({
  type: _zod.z.literal('wildcard'),
  field: _primitives.NonEmptyString,
  value: _primitives.NonEmptyString,
  operator: ExceptionListItemEntryOperator
});
const ExceptionListItemEntryInternal = exports.ExceptionListItemEntryInternal = _zod.z.discriminatedUnion('type', [ExceptionListItemEntryMatch, ExceptionListItemEntryMatchAny, ExceptionListItemEntryList, ExceptionListItemEntryExists, ExceptionListItemEntryNested, ExceptionListItemEntryMatchWildcard]);
const ExceptionListItemEntry = exports.ExceptionListItemEntry = ExceptionListItemEntryInternal;
const ExceptionListItemEntryArray = exports.ExceptionListItemEntryArray = _zod.z.array(ExceptionListItemEntry);