"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_PRODUCT_MESSAGE = exports.SIEM_MIGRATION_UPSELLING_TITLE = exports.SIEM_MIGRATION_UPGRADE_MESSAGE = exports.SIEM_MIGRATION_RULES_PAGE_UPGRADE_LICENSE_MESSAGE = exports.ADDITIONAL_CHARGES_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPGRADE_PRODUCT_MESSAGE = requiredProduct => _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.entityAnalytics.upgradeProductMessage', {
  defaultMessage: 'Entity risk scoring capability is available in our {requiredProduct} license tier',
  values: {
    requiredProduct
  }
});
exports.UPGRADE_PRODUCT_MESSAGE = UPGRADE_PRODUCT_MESSAGE;
const ADDITIONAL_CHARGES_MESSAGE = exports.ADDITIONAL_CHARGES_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionServerless.entityStoreEnablementCallout.additionalChargesMessage', {
  defaultMessage: 'Please be aware that activating these features may incur additional charges depending on your subscription plan. Review your plan details carefully to avoid unexpected costs before proceeding.'
});
const SIEM_MIGRATION_UPSELLING_TITLE = requiredTier => _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.siemMigrations.title', {
  defaultMessage: 'Security {requiredTier} tier required',
  values: {
    requiredTier
  }
});
exports.SIEM_MIGRATION_UPSELLING_TITLE = SIEM_MIGRATION_UPSELLING_TITLE;
const SIEM_MIGRATION_UPGRADE_MESSAGE = exports.SIEM_MIGRATION_UPGRADE_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.siemMigrations.upgradeTierMessage', {
  defaultMessage: 'To use this feature, you need to upgrade your Elastic Cloud Serverless feature tier. Update your subscription or contact your administrator for assistance.'
});
const SIEM_MIGRATION_RULES_PAGE_UPGRADE_LICENSE_MESSAGE = exports.SIEM_MIGRATION_RULES_PAGE_UPGRADE_LICENSE_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.siemMigrations.rulesPageUpgradeLicenseMessage', {
  defaultMessage: 'To use this feature, you need to upgrade your Elastic Cloud Serverless feature tier. Update your subscription or contact your administrator for assistance. If you have created a migration previously, you will be able to access it after upgrade.'
});