"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpacesUsage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Calculates the usage of spaces based on the provided rule results.
 *
 * @param {Array<SavedObjectsFindResult<RuleSearchResult>>} ruleResults - An array of saved object results containing rule search results.
 *
 * @returns {SpacesUsage}
 * - `total`: The total number spaces rules belong to.
 * - `rules_in_spaces`: An array where each value represents the number of rules in a specific space.
 */
const getSpacesUsage = ruleResults => {
  const spacesUsageMap = new Map();

  // for loop is faster
  for (let i = 0; i < ruleResults.length; i++) {
    var _rule$namespaces;
    const rule = ruleResults[i];
    const space = (_rule$namespaces = rule.namespaces) === null || _rule$namespaces === void 0 ? void 0 : _rule$namespaces[0];
    if (space) {
      var _spacesUsageMap$get;
      spacesUsageMap.set(space, ((_spacesUsageMap$get = spacesUsageMap.get(space)) !== null && _spacesUsageMap$get !== void 0 ? _spacesUsageMap$get : 0) + 1);
    }
  }
  return {
    total: spacesUsageMap.size,
    rules_in_spaces: Array.from(spacesUsageMap.values())
  };
};
exports.getSpacesUsage = getSpacesUsage;