"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putCriblRoutingPipeline = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _translator = require("../../../common/security_integrations/cribl/translator");
var _pipeline_builder = require("../../lib/security_integrations/cribl/util/pipeline_builder");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putCriblRoutingPipeline = async (esClient, policy, logger) => {
  const mappings = (0, _translator.getRouteEntriesFromPolicyConfig)(policy.vars);
  const pipelineConf = (0, _pipeline_builder.buildPipelineRequest)(mappings);
  await createOrUpdatePipeline(esClient, pipelineConf, logger);
};
exports.putCriblRoutingPipeline = putCriblRoutingPipeline;
const createOrUpdatePipeline = async (esClient, pipelineConf, logger) => {
  try {
    await esClient.transport.request({
      method: 'PUT',
      path: `_ingest/pipeline/${_constants.SECURITY_INTEGRATIONS_CRIBL_ROUTING_PIPELINE}`,
      body: pipelineConf
    });
    return true;
  } catch (e) {
    const error = (0, _securitysolutionEsUtils.transformError)(e);
    logger.error(`Failed to put Cribl integration routing pipeline. error: ${error.message}`);
  }
  return false;
};