"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestEndpointPackagePoliciesStatsSearch = exports.endpointPackagePoliciesStatsSearchStrategyProvider = void 0;
var _rxjs = require("rxjs");
var _moment = _interopRequireDefault(require("moment"));
var _errors = require("../../endpoint/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointPackagePoliciesStatsSearchStrategyProvider = context => {
  return {
    search: (_, __, deps) => {
      return (0, _rxjs.from)(requestEndpointPackagePoliciesStatsSearch(context, deps));
    }
  };
};
exports.endpointPackagePoliciesStatsSearchStrategyProvider = endpointPackagePoliciesStatsSearchStrategyProvider;
const requestEndpointPackagePoliciesStatsSearch = async (context, deps) => {
  const {
    canReadEndpointList
  } = await context.getEndpointAuthz(deps.request);
  if (!canReadEndpointList) {
    throw new _errors.EndpointAuthorizationError();
  }
  const fleetServices = context.getInternalFleetServices();
  const rawResponse = await fleetServices.packagePolicy.list(deps.savedObjectsClient, {
    perPage: 10000,
    page: 1,
    kuery: `ingest-package-policies.package.name:"endpoint"`
  });
  const outdatedManifestsCount = rawResponse.items.reduce((acc, item) => {
    var _endpointInput$config, _endpointInput$config2, _endpointInput$config3;
    const endpointInput = item.inputs.find(input => input.type === 'endpoint');
    if (!endpointInput) {
      return acc;
    }
    const manifestVersion = (_endpointInput$config = endpointInput.config) === null || _endpointInput$config === void 0 ? void 0 : (_endpointInput$config2 = _endpointInput$config.policy) === null || _endpointInput$config2 === void 0 ? void 0 : (_endpointInput$config3 = _endpointInput$config2.value) === null || _endpointInput$config3 === void 0 ? void 0 : _endpointInput$config3.global_manifest_version;
    if (!manifestVersion) {
      return acc;
    }
    if (manifestVersion === 'latest') {
      return acc;
    }
    if (_moment.default.utc(manifestVersion, 'YYYY-MM-DD').isBefore(_moment.default.utc().subtract(1, 'month'))) {
      return acc + 1;
    }
    return acc;
  }, 0);
  return {
    rawResponse: {
      outdatedManifestsCount
    },
    isRunning: false,
    isPartial: false
  };
};
exports.requestEndpointPackagePoliciesStatsSearch = requestEndpointPackagePoliciesStatsSearch;