"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryType = exports.Action = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Enum defining the types of actions that can be applied to data,
 * such as masking or keeping the original value, as part of the
 * filterlist transformation.
 */
let Action = exports.Action = /*#__PURE__*/function (Action) {
  Action["MASK"] = "mask";
  Action["KEEP"] = "keep";
  return Action;
}({});
/**
 * Enumeration of the supported query types.
 */
let QueryType = exports.QueryType = /*#__PURE__*/function (QueryType) {
  QueryType["DSL"] = "DSL";
  QueryType["EQL"] = "EQL";
  QueryType["ESQL"] = "ESQL";
  return QueryType;
}({});
/**
 * Configuration interface for Health Diagnostic query execution.
 */
/**
 * Defines a health diagnostic query configuration with scheduling and filtering options.
 */