"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryConfiguration = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _os = _interopRequireDefault(require("os"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryConfigurationDTO {
  constructor() {
    (0, _defineProperty2.default)(this, "DEFAULT_TELEMETRY_MAX_BUFFER_SIZE", 100);
    (0, _defineProperty2.default)(this, "DEFAULT_MAX_SECURITY_LIST_TELEMETRY_BATCH", 100);
    (0, _defineProperty2.default)(this, "DEFAULT_MAX_ENDPOINT_TELEMETRY_BATCH", 300);
    (0, _defineProperty2.default)(this, "DEFAULT_MAX_DETECTION_RULE_TELEMETRY_BATCH", 1_000);
    (0, _defineProperty2.default)(this, "DEFAULT_MAX_DETECTION_ALERTS_BATCH", 50);
    (0, _defineProperty2.default)(this, "DEFAULT_ASYNC_SENDER", false);
    (0, _defineProperty2.default)(this, "DEFAULT_SENDER_CHANNELS", {});
    (0, _defineProperty2.default)(this, "DEFAULT_PAGINATION_CONFIG", {
      // default to 2% of host's total memory or 80MiB, whichever is smaller
      max_page_size_bytes: Math.min(_os.default.totalmem() * 0.02, 80 * 1024 * 1024),
      num_docs_to_sample: 10
    });
    (0, _defineProperty2.default)(this, "DEFAULT_INDICES_METADATA_CONFIG", {
      indices_threshold: 10_000,
      datastreams_threshold: 1000,
      indices_settings_threshold: 10_000,
      index_query_size: 1024,
      ilm_stats_query_size: 1024,
      ilm_policy_query_size: 1024,
      max_prefixes: 10,
      // @deprecated
      max_group_size: 100,
      // @deprecated
      min_group_size: 5 // @deprecated
    });
    (0, _defineProperty2.default)(this, "DEFAULT_INGEST_PIPELINES_STATS_CONFIG", {
      enabled: true
    });
    (0, _defineProperty2.default)(this, "DEFAULT_HEALTH_DIAGNOSTIC_CONFIG", {
      query: {
        maxDocuments: 10_000,
        bufferSize: 1_000
      },
      rssGrowthCircuitBreaker: {
        maxRssGrowthPercent: 40,
        validationIntervalMs: 500
      },
      timeoutCircuitBreaker: {
        timeoutMillis: 5000,
        validationIntervalMs: 500
      },
      eventLoopUtilizationCircuitBreaker: {
        thresholdMillis: 5000,
        validationIntervalMs: 500
      },
      eventLoopDelayCircuitBreaker: {
        thresholdMillis: 500,
        validationIntervalMs: 250
      },
      elasticsearchCircuitBreaker: {
        maxJvmHeapUsedPercent: 90,
        maxCpuPercent: 90,
        expectedClusterHealth: ['green', 'yellow'],
        validationIntervalMs: 1000
      }
    });
    (0, _defineProperty2.default)(this, "DEFAULT_QUERY_CONFIG", {
      pageSize: 500,
      maxResponseSize: 10 * 1024 * 1024,
      // 10 MB
      maxCompressedResponseSize: 8 * 1024 * 1024 // 8 MB
    });
    (0, _defineProperty2.default)(this, "_telemetry_max_buffer_size", this.DEFAULT_TELEMETRY_MAX_BUFFER_SIZE);
    (0, _defineProperty2.default)(this, "_max_security_list_telemetry_batch", this.DEFAULT_MAX_SECURITY_LIST_TELEMETRY_BATCH);
    (0, _defineProperty2.default)(this, "_max_endpoint_telemetry_batch", this.DEFAULT_MAX_ENDPOINT_TELEMETRY_BATCH);
    (0, _defineProperty2.default)(this, "_max_detection_rule_telemetry_batch", this.DEFAULT_MAX_DETECTION_RULE_TELEMETRY_BATCH);
    (0, _defineProperty2.default)(this, "_max_detection_alerts_batch", this.DEFAULT_MAX_DETECTION_ALERTS_BATCH);
    (0, _defineProperty2.default)(this, "_use_async_sender", this.DEFAULT_ASYNC_SENDER);
    (0, _defineProperty2.default)(this, "_sender_channels", this.DEFAULT_SENDER_CHANNELS);
    (0, _defineProperty2.default)(this, "_pagination_config", this.DEFAULT_PAGINATION_CONFIG);
    (0, _defineProperty2.default)(this, "_indices_metadata_config", this.DEFAULT_INDICES_METADATA_CONFIG);
    (0, _defineProperty2.default)(this, "_ingest_pipelines_stats_config", this.DEFAULT_INGEST_PIPELINES_STATS_CONFIG);
    (0, _defineProperty2.default)(this, "_health_diagnostic_config", this.DEFAULT_HEALTH_DIAGNOSTIC_CONFIG);
    (0, _defineProperty2.default)(this, "_query_config", this.DEFAULT_QUERY_CONFIG);
  }
  get telemetry_max_buffer_size() {
    return this._telemetry_max_buffer_size;
  }
  set telemetry_max_buffer_size(num) {
    this._telemetry_max_buffer_size = num;
  }
  get max_security_list_telemetry_batch() {
    return this._max_security_list_telemetry_batch;
  }
  set max_security_list_telemetry_batch(num) {
    this._max_security_list_telemetry_batch = num;
  }
  get max_endpoint_telemetry_batch() {
    return this._max_endpoint_telemetry_batch;
  }
  set max_endpoint_telemetry_batch(num) {
    this._max_endpoint_telemetry_batch = num;
  }
  get max_detection_rule_telemetry_batch() {
    return this._max_detection_rule_telemetry_batch;
  }
  set max_detection_rule_telemetry_batch(num) {
    this._max_detection_rule_telemetry_batch = num;
  }
  get max_detection_alerts_batch() {
    return this._max_detection_alerts_batch;
  }
  set max_detection_alerts_batch(num) {
    this._max_detection_alerts_batch = num;
  }
  get use_async_sender() {
    return this._use_async_sender;
  }
  set use_async_sender(num) {
    this._use_async_sender = num;
  }
  set sender_channels(config) {
    this._sender_channels = config;
  }
  get sender_channels() {
    return this._sender_channels;
  }
  set pagination_config(paginationConfiguration) {
    this._pagination_config = paginationConfiguration;
  }
  get pagination_config() {
    return this._pagination_config;
  }
  set indices_metadata_config(indicesMetadataConfiguration) {
    this._indices_metadata_config = indicesMetadataConfiguration;
  }
  get indices_metadata_config() {
    return this._indices_metadata_config;
  }
  set ingest_pipelines_stats_config(ingestPipelinesStatsConfiguration) {
    this._ingest_pipelines_stats_config = ingestPipelinesStatsConfiguration;
  }
  get ingest_pipelines_stats_config() {
    return this._ingest_pipelines_stats_config;
  }
  set health_diagnostic_config(healthDiagnosticConfiguration) {
    this._health_diagnostic_config = healthDiagnosticConfiguration;
  }
  get health_diagnostic_config() {
    return this._health_diagnostic_config;
  }
  set query_config(queryConfiguration) {
    this._query_config = queryConfiguration;
  }
  get query_config() {
    return this._query_config;
  }
  resetAllToDefault() {
    this._telemetry_max_buffer_size = this.DEFAULT_TELEMETRY_MAX_BUFFER_SIZE;
    this._max_security_list_telemetry_batch = this.DEFAULT_MAX_SECURITY_LIST_TELEMETRY_BATCH;
    this._max_endpoint_telemetry_batch = this.DEFAULT_MAX_ENDPOINT_TELEMETRY_BATCH;
    this._max_detection_rule_telemetry_batch = this.DEFAULT_MAX_DETECTION_RULE_TELEMETRY_BATCH;
    this._max_detection_alerts_batch = this.DEFAULT_MAX_DETECTION_ALERTS_BATCH;
    this._sender_channels = this.DEFAULT_SENDER_CHANNELS;
    this._pagination_config = this.DEFAULT_PAGINATION_CONFIG;
    this._indices_metadata_config = this.DEFAULT_INDICES_METADATA_CONFIG;
    this._ingest_pipelines_stats_config = this.DEFAULT_INGEST_PIPELINES_STATS_CONFIG;
    this._health_diagnostic_config = this.DEFAULT_HEALTH_DIAGNOSTIC_CONFIG;
    this._query_config = this.DEFAULT_QUERY_CONFIG;
  }
}
const telemetryConfiguration = exports.telemetryConfiguration = new TelemetryConfigurationDTO();