"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslateRuleGraph = getTranslateRuleGraph;
var _langgraph = require("@langchain/langgraph");
var _fp = require("lodash/fp");
var _ecs_mapping = require("./nodes/ecs_mapping");
var _fix_query_errors = require("./nodes/fix_query_errors");
var _inline_query = require("./nodes/inline_query");
var _retrieve_integrations = require("./nodes/retrieve_integrations");
var _translate_rule = require("./nodes/translate_rule");
var _translation_result = require("./nodes/translation_result");
var _validation = require("./nodes/validation");
var _state = require("./state");
var _state2 = require("../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// How many times we will try to self-heal when validation fails, to prevent infinite graph recursions
const MAX_VALIDATION_ITERATIONS = 3;
function getTranslateRuleGraph({
  model,
  esqlKnowledgeBase,
  ruleMigrationsRetriever,
  logger,
  telemetryClient
}) {
  const translateRuleNode = (0, _translate_rule.getTranslateRuleNode)({
    esqlKnowledgeBase,
    logger
  });
  const translationResultNode = (0, _translation_result.getTranslationResultNode)();
  const inlineQueryNode = (0, _inline_query.getInlineQueryNode)({
    model,
    logger
  });
  const validationNode = (0, _validation.getValidationNode)({
    logger
  });
  const fixQueryErrorsNode = (0, _fix_query_errors.getFixQueryErrorsNode)({
    esqlKnowledgeBase,
    logger
  });
  const retrieveIntegrationsNode = (0, _retrieve_integrations.getRetrieveIntegrationsNode)({
    model,
    ruleMigrationsRetriever,
    telemetryClient
  });
  const ecsMappingNode = (0, _ecs_mapping.getEcsMappingNode)({
    esqlKnowledgeBase,
    logger
  });
  const translateRuleGraph = new _langgraph.StateGraph(_state.translateRuleState, _state2.migrateRuleConfigSchema)
  // Nodes
  .addNode('inlineQuery', inlineQueryNode).addNode('retrieveIntegrations', retrieveIntegrationsNode).addNode('translateRule', translateRuleNode).addNode('validation', validationNode).addNode('fixQueryErrors', fixQueryErrorsNode).addNode('ecsMapping', ecsMappingNode).addNode('translationResult', translationResultNode)
  // Edges
  .addEdge(_langgraph.START, 'inlineQuery').addConditionalEdges('inlineQuery', translatableRouter, ['retrieveIntegrations', 'translationResult']).addEdge('retrieveIntegrations', 'translateRule').addEdge('translateRule', 'validation').addEdge('fixQueryErrors', 'validation').addEdge('ecsMapping', 'validation').addConditionalEdges('validation', validationRouter, ['fixQueryErrors', 'ecsMapping', 'translationResult']).addEdge('translationResult', _langgraph.END);
  const graph = translateRuleGraph.compile();
  graph.name = 'Translate Rule Graph';
  return graph;
}
const translatableRouter = state => {
  if (!state.inline_query) {
    return 'translationResult';
  }
  return 'retrieveIntegrations';
};
const validationRouter = state => {
  var _state$validation_err;
  if (state.validation_errors.iterations <= MAX_VALIDATION_ITERATIONS && !(0, _fp.isEmpty)((_state$validation_err = state.validation_errors) === null || _state$validation_err === void 0 ? void 0 : _state$validation_err.esql_errors)) {
    return 'fixQueryErrors';
  }
  if (!state.includes_ecs_mapping) {
    return 'ecsMapping';
  }
  return 'translationResult';
};