"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityIndexComponentTemplateStatus = exports.deleteEntityIndexComponentTemplate = exports.createEntityIndexComponentTemplate = void 0;
var _entity_analytics = require("../../../../../common/api/entity_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getComponentTemplateName = definitionId => `${definitionId}-latest@platform`;
const createEntityIndexComponentTemplate = (description, esClient) => {
  const {
    id,
    indexMappings
  } = description;
  const name = getComponentTemplateName(id);
  return esClient.cluster.putComponentTemplate({
    name,
    body: {
      template: {
        settings: {
          hidden: true
        },
        mappings: indexMappings
      }
    }
  });
};
exports.createEntityIndexComponentTemplate = createEntityIndexComponentTemplate;
const deleteEntityIndexComponentTemplate = ({
  id,
  esClient
}) => {
  const name = getComponentTemplateName(id);
  return esClient.cluster.deleteComponentTemplate({
    name
  }, {
    ignore: [404]
  });
};
exports.deleteEntityIndexComponentTemplate = deleteEntityIndexComponentTemplate;
const getEntityIndexComponentTemplateStatus = async ({
  definitionId,
  esClient
}) => {
  var _componentTemplate$co;
  const name = getComponentTemplateName(definitionId);
  const componentTemplate = await esClient.cluster.getComponentTemplate({
    name
  }, {
    ignore: [404]
  });
  return {
    id: name,
    installed: (componentTemplate === null || componentTemplate === void 0 ? void 0 : (_componentTemplate$co = componentTemplate.component_templates) === null || _componentTemplate$co === void 0 ? void 0 : _componentTemplate$co.length) > 0,
    resource: _entity_analytics.EngineComponentResourceEnum.component_template
  };
};
exports.getEntityIndexComponentTemplateStatus = getEntityIndexComponentTemplateStatus;