"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityInternalStatusRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _audit = require("../../audit");
var _audit2 = require("../audit");
var _check_and_init_asset_criticality_resources = require("../check_and_init_asset_criticality_resources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityInternalStatusRoute = (router, logger) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.ASSET_CRITICALITY_INTERNAL_STATUS_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _securitySolution$get;
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const securitySolution = await context.securitySolution;
      const assetCriticalityClient = securitySolution.getAssetCriticalityDataClient();
      const result = await assetCriticalityClient.getStatus();
      (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
        message: 'User checked the status of the asset criticality service',
        event: {
          action: _audit2.AssetCriticalityAuditActions.ASSET_CRITICALITY_STATUS_GET,
          category: _audit.AUDIT_CATEGORY.DATABASE,
          type: _audit.AUDIT_TYPE.ACCESS,
          outcome: _audit.AUDIT_OUTCOME.UNKNOWN
        }
      });
      return response.ok({
        body: {
          asset_criticality_resources_installed: result.isAssetCriticalityResourcesInstalled
        }
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.assetCriticalityInternalStatusRoute = assetCriticalityInternalStatusRoute;