"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataTierFilter = void 0;
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * reads Kibana advanced settings for filtering data tiers during rule executions
 * returns {@link Filter} array
 */
const getDataTierFilter = async ({
  uiSettingsClient
}) => {
  const excludedTiers = await uiSettingsClient.get(_constants.EXCLUDED_DATA_TIERS_FOR_RULE_EXECUTION);
  if (!(excludedTiers !== null && excludedTiers !== void 0 && excludedTiers.length)) {
    return [];
  }
  return [{
    meta: {
      negate: true
    },
    query: {
      terms: {
        _tier: excludedTiers
      }
    }
  }];
};
exports.getDataTierFilter = getDataTierFilter;