"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserAssetCriticalityEnrichments = exports.createServiceAssetCriticalityEnrichments = exports.createHostAssetCriticalityEnrichments = void 0;
var _lodash = require("lodash");
var _field_names = require("../../../../../../../common/field_maps/field_names");
var _create_single_field_match_enrichment = require("../create_single_field_match_enrichment");
var _events = require("../utils/events");
var _asset_criticality = require("../../../../../../../common/entity_analytics/asset_criticality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enrichmentResponseFields = ['id_value', 'criticality_level'];
const getExtraFiltersForEnrichment = field => [{
  match: {
    id_field: {
      query: field
    }
  }
}];
const createEnrichmentFactoryFunction = alertField => enrichment => event => {
  const criticality = (0, _events.getFieldValue)(enrichment, 'criticality_level');
  if (!criticality) {
    return event;
  }
  const newEvent = (0, _lodash.cloneDeep)(event);
  if (criticality && newEvent._source) {
    newEvent._source[alertField] = criticality;
  }
  return newEvent;
};
const createHostAssetCriticalityEnrichments = async ({
  services,
  logger,
  events,
  spaceId
}) => {
  return (0, _create_single_field_match_enrichment.createSingleFieldMatchEnrichment)({
    name: 'Host Asset Criticality',
    index: [(0, _asset_criticality.getAssetCriticalityIndex)(spaceId)],
    services,
    logger,
    events,
    mappingField: {
      eventField: 'host.name',
      enrichmentField: 'id_value'
    },
    enrichmentResponseFields,
    extraFilters: getExtraFiltersForEnrichment('host.name'),
    createEnrichmentFunction: createEnrichmentFactoryFunction(_field_names.ALERT_HOST_CRITICALITY)
  });
};
exports.createHostAssetCriticalityEnrichments = createHostAssetCriticalityEnrichments;
const createUserAssetCriticalityEnrichments = async ({
  services,
  logger,
  events,
  spaceId
}) => {
  return (0, _create_single_field_match_enrichment.createSingleFieldMatchEnrichment)({
    name: 'User Asset Criticality',
    index: [(0, _asset_criticality.getAssetCriticalityIndex)(spaceId)],
    services,
    logger,
    events,
    mappingField: {
      eventField: 'user.name',
      enrichmentField: 'id_value'
    },
    enrichmentResponseFields,
    extraFilters: getExtraFiltersForEnrichment('user.name'),
    createEnrichmentFunction: createEnrichmentFactoryFunction(_field_names.ALERT_USER_CRITICALITY)
  });
};
exports.createUserAssetCriticalityEnrichments = createUserAssetCriticalityEnrichments;
const createServiceAssetCriticalityEnrichments = async ({
  services,
  logger,
  events,
  spaceId
}) => {
  return (0, _create_single_field_match_enrichment.createSingleFieldMatchEnrichment)({
    name: 'Service Asset Criticality',
    index: [(0, _asset_criticality.getAssetCriticalityIndex)(spaceId)],
    services,
    logger,
    events,
    mappingField: {
      eventField: 'service.name',
      enrichmentField: 'id_value'
    },
    enrichmentResponseFields,
    extraFilters: getExtraFiltersForEnrichment('service.name'),
    createEnrichmentFunction: createEnrichmentFactoryFunction(_field_names.ALERT_SERVICE_CRITICALITY)
  });
};
exports.createServiceAssetCriticalityEnrichments = createServiceAssetCriticalityEnrichments;