"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkErrorDetails = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_ERRORS_EXCEPTIONS = ['status_exception', 'verification_exception', 'parsing_exception'];

/**
 * if error can be qualified as user error(configurational), returns isUserError: true
 * user errors are excluded from SLO dashboards
 */
const checkErrorDetails = error => {
  var _errBody, _errBody$error;
  const errorType = error === null || error === void 0 ? void 0 : (_errBody = error.errBody) === null || _errBody === void 0 ? void 0 : (_errBody$error = _errBody.error) === null || _errBody$error === void 0 ? void 0 : _errBody$error.type;
  if (USER_ERRORS_EXCEPTIONS.includes(errorType)) {
    return {
      isUserError: true
    };
  }
  const isUserError = error instanceof Error && USER_ERRORS_EXCEPTIONS.some(exception => error.message.includes(exception));
  return {
    isUserError
  };
};
exports.checkErrorDetails = checkErrorDetails;