"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findThresholdSignals = void 0;
var _lodash = require("lodash");
var _single_search_after = require("../utils/single_search_after");
var _build_events_query = require("../utils/build_events_query");
var _build_threshold_aggregation = require("./build_threshold_aggregation");
var _utils = require("./utils");
var _utils2 = require("../utils/utils");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasThresholdFields = threshold => !!threshold.field.length;
const findThresholdSignals = async ({
  from,
  to,
  maxSignals,
  inputIndexPattern,
  services,
  ruleExecutionLogger,
  filter,
  threshold,
  runtimeMappings,
  primaryTimestamp,
  secondaryTimestamp,
  aggregatableTimestampField,
  isLoggedRequestsEnabled
}) => {
  // Leaf aggregations used below
  const buckets = [];
  const searchAfterResults = {
    searchDurations: [],
    searchErrors: []
  };
  const warnings = [];
  const loggedRequests = [];
  const includeCardinalityFilter = (0, _utils.shouldFilterByCardinality)(threshold);
  if (hasThresholdFields(threshold)) {
    let sortKeys;
    do {
      const searchRequest = (0, _build_events_query.buildEventsSearchQuery)({
        aggregations: (0, _build_threshold_aggregation.buildThresholdMultiBucketAggregation)({
          threshold,
          aggregatableTimestampField,
          sortKeys
        }),
        index: inputIndexPattern,
        from,
        to,
        runtimeMappings,
        filter,
        size: 0,
        sortOrder: 'desc',
        searchAfterSortIds: undefined,
        primaryTimestamp,
        secondaryTimestamp
      });
      const {
        searchResult,
        searchDuration,
        searchErrors,
        loggedRequests: thresholdLoggedRequests
      } = await (0, _single_search_after.singleSearchAfter)({
        searchRequest,
        services,
        ruleExecutionLogger,
        loggedRequestsConfig: isLoggedRequestsEnabled ? {
          type: 'findThresholdBuckets',
          description: i18n.FIND_THRESHOLD_BUCKETS_DESCRIPTION((0, _utils2.stringifyAfterKey)(sortKeys)),
          skipRequestQuery: loggedRequests.length > 2
        } : undefined
      });
      searchAfterResults.searchDurations.push(searchDuration);
      loggedRequests.push(...(thresholdLoggedRequests !== null && thresholdLoggedRequests !== void 0 ? thresholdLoggedRequests : []));
      if (!(0, _lodash.isEmpty)(searchErrors)) {
        searchAfterResults.searchErrors.push(...searchErrors);
        sortKeys = undefined; // this will eject us out of the loop
        // if a search failure occurs on a secondary iteration,
        // we will return early.
      } else if (searchResult.aggregations != null) {
        const thresholdTerms = searchResult.aggregations.thresholdTerms;
        sortKeys = thresholdTerms.after_key;
        buckets.push(...thresholdTerms.buckets);
      } else {
        throw new Error('Aggregations were missing on threshold rule search result');
      }
    } while (sortKeys && buckets.length <= maxSignals);
  } else {
    const searchRequest = (0, _build_events_query.buildEventsSearchQuery)({
      aggregations: (0, _build_threshold_aggregation.buildThresholdSingleBucketAggregation)({
        threshold,
        aggregatableTimestampField
      }),
      index: inputIndexPattern,
      from,
      to,
      runtimeMappings,
      filter,
      size: 0,
      sortOrder: 'desc',
      searchAfterSortIds: undefined,
      primaryTimestamp,
      secondaryTimestamp
    });
    const {
      searchResult,
      searchDuration,
      searchErrors,
      loggedRequests: thresholdLoggedRequests
    } = await (0, _single_search_after.singleSearchAfter)({
      searchRequest,
      services,
      ruleExecutionLogger,
      loggedRequestsConfig: isLoggedRequestsEnabled ? {
        type: 'findThresholdBuckets',
        description: i18n.FIND_THRESHOLD_BUCKETS_DESCRIPTION()
      } : undefined
    });
    searchAfterResults.searchDurations.push(searchDuration);
    searchAfterResults.searchErrors.push(...searchErrors);
    loggedRequests.push(...(thresholdLoggedRequests !== null && thresholdLoggedRequests !== void 0 ? thresholdLoggedRequests : []));
    if ((0, _lodash.isEmpty)(searchErrors)) {
      searchAfterResults.searchErrors.push(...searchErrors);
    } else if (searchResult.aggregations != null) {
      var _searchResult$aggrega, _searchResult$aggrega2, _searchResult$aggrega3;
      const docCount = searchResult.hits.total.value;
      if (docCount >= threshold.value && (!includeCardinalityFilter || ((_searchResult$aggrega = searchResult === null || searchResult === void 0 ? void 0 : (_searchResult$aggrega2 = searchResult.aggregations) === null || _searchResult$aggrega2 === void 0 ? void 0 : (_searchResult$aggrega3 = _searchResult$aggrega2.cardinality_count) === null || _searchResult$aggrega3 === void 0 ? void 0 : _searchResult$aggrega3.value) !== null && _searchResult$aggrega !== void 0 ? _searchResult$aggrega : 0) >= threshold.cardinality[0].value)) {
        buckets.push({
          doc_count: docCount,
          key: {},
          max_timestamp: searchResult.aggregations.max_timestamp,
          min_timestamp: searchResult.aggregations.min_timestamp,
          cardinality_count: searchResult.aggregations.cardinality_count
        });
      }
    } else {
      throw new Error('Aggregations were missing on threshold rule search result');
    }
  }
  if (buckets.length > maxSignals) {
    warnings.push((0, _utils2.getMaxSignalsWarning)());
  }
  return {
    buckets: buckets.slice(0, maxSignals),
    ...searchAfterResults,
    warnings,
    ...(isLoggedRequestsEnabled ? {
      loggedRequests
    } : {})
  };
};
exports.findThresholdSignals = findThresholdSignals;