"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createQueryAlertType = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _query = require("./query");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createQueryAlertType = createOptions => {
  const {
    id,
    name
  } = createOptions;
  return {
    id,
    name,
    validate: {
      params: {
        validate: object => {
          return _rule_schema.UnifiedQueryRuleParams.parse(object);
        },
        /**
         * validate rule params when rule is bulk edited (update and created in future as well)
         * returned params can be modified (useful in case of version increment)
         * @param mutatedRuleParams
         * @returns mutatedRuleParams
         */
        validateMutatedParams: mutatedRuleParams => {
          (0, _utils.validateIndexPatterns)(mutatedRuleParams.index);
          return mutatedRuleParams;
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _rule_schema.UnifiedQueryRuleParams
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    solution: 'security',
    async executor(execOptions) {
      const {
        sharedParams,
        services,
        state
      } = execOptions;
      return (0, _query.queryExecutor)({
        sharedParams,
        eventsTelemetry: sharedParams.eventsTelemetry,
        services,
        bucketHistory: state.suppressionGroupHistory,
        licensing: sharedParams.licensing,
        scheduleNotificationResponseActionsService: sharedParams.scheduleNotificationResponseActionsService,
        isLoggedRequestsEnabled: Boolean(state === null || state === void 0 ? void 0 : state.isLoggedRequestsEnabled)
      });
    }
  };
};
exports.createQueryAlertType = createQueryAlertType;