"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateHistoryWindowStart = exports.transformBucketsToValues = exports.parseDateString = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseDateString = ({
  date,
  forceNow,
  name
}) => {
  const parsedDate = _datemath.default.parse(date, {
    forceNow
  });
  if (parsedDate == null || !parsedDate.isValid()) {
    throw Error(`Failed to parse '${name !== null && name !== void 0 ? name : 'date string'}'`);
  }
  return parsedDate;
};
exports.parseDateString = parseDateString;
const validateHistoryWindowStart = ({
  historyWindowStart,
  from
}) => {
  const forceNow = (0, _moment.default)().toDate();
  const parsedHistoryWindowStart = parseDateString({
    date: historyWindowStart,
    forceNow,
    name: 'historyWindowStart'
  });
  const parsedFrom = parseDateString({
    date: from,
    forceNow,
    name: 'from'
  });
  if (parsedHistoryWindowStart.isSameOrAfter(parsedFrom)) {
    throw Error(`History window size is smaller than rule interval + additional lookback, 'historyWindowStart' must be earlier than 'from'`);
  }
};

/**
 * Takes a list of buckets and creates value from them to be used in 'include' clause of terms aggregation.
 * For a single new terms field, value equals to bucket name
 * Otherwise throws error
 * @returns
 */
exports.validateHistoryWindowStart = validateHistoryWindowStart;
const transformBucketsToValues = (newTermsFields, buckets) => {
  // if new terms include only one field we don't use runtime mappings and don't stitch fields buckets together
  if (newTermsFields.length === 1) {
    return buckets.map(bucket => Object.values(bucket.key)[0]).filter(value => value != null);
  }
  throw Error('Can be used for single new terms field only');
};
exports.transformBucketsToValues = transformBucketsToValues;