"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMlAlertType = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _get_is_alert_suppression_active = require("../utils/get_is_alert_suppression_active");
var _ml = require("./ml");
var _wrap_suppressed_alerts = require("../utils/wrap_suppressed_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMlAlertType = ml => {
  return {
    id: _securitysolutionRules.ML_RULE_TYPE_ID,
    name: 'Machine Learning Rule',
    validate: {
      params: {
        validate: object => {
          return _rule_schema.MachineLearningRuleParams.parse(object);
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _rule_schema.MachineLearningRuleParams
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    solution: 'security',
    async executor(execOptions) {
      const {
        sharedParams,
        services,
        state
      } = execOptions;
      const isAlertSuppressionActive = await (0, _get_is_alert_suppression_active.getIsAlertSuppressionActive)({
        alertSuppression: sharedParams.completeRule.ruleParams.alertSuppression,
        licensing: sharedParams.licensing
      });
      const isLoggedRequestsEnabled = Boolean(state === null || state === void 0 ? void 0 : state.isLoggedRequestsEnabled);
      const wrapSuppressedHits = (events, buildReasonMessage) => (0, _wrap_suppressed_alerts.wrapSuppressedAlerts)({
        events,
        buildReasonMessage,
        sharedParams
      });
      const {
        result,
        loggedRequests
      } = await (0, _ml.mlExecutor)({
        sharedParams,
        ml,
        services,
        wrapSuppressedHits,
        isAlertSuppressionActive,
        scheduleNotificationResponseActionsService: sharedParams.scheduleNotificationResponseActionsService,
        isLoggedRequestsEnabled
      });
      return {
        ...result,
        state,
        ...(isLoggedRequestsEnabled ? {
          loggedRequests
        } : {})
      };
    }
  };
};
exports.createMlAlertType = createMlAlertType;