"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMvExpandUsage = void 0;
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMvExpandUsage = (columns, query) => {
  const expandedFieldsFromQuery = (0, _securitysolutionUtils.getMvExpandFields)(query);
  if (expandedFieldsFromQuery.length === 0) {
    return {
      hasMvExpand: false
    };
  }
  const columnNamesSet = columns.reduce((acc, column) => {
    acc.add(column.name);
    return acc;
  }, new Set());
  const hasExpandedFieldsMissed = expandedFieldsFromQuery.some(field => !columnNamesSet.has(field));
  const expandedFieldsInResponse = hasExpandedFieldsMissed ? [] : expandedFieldsFromQuery;
  return {
    hasMvExpand: expandedFieldsFromQuery.length > 0,
    expandedFieldsInResponse
  };
};
exports.getMvExpandUsage = getMvExpandUsage;